/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile;

import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.automobile.AutomobileComponent;
import io.github.foundationgames.automobility.automobile.DisplayStat;
import io.github.foundationgames.automobility.automobile.WheelBase;
import io.github.foundationgames.automobility.util.SimpleMapContentRegistry;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;

public record AutomobileFrame(ResourceLocation id, float weight, FrameModel model) implements AutomobileComponent<AutomobileFrame>
{
    public static final ResourceLocation ID = Automobility.rl("frame");
    public static final SimpleMapContentRegistry<AutomobileFrame> REGISTRY = new SimpleMapContentRegistry();
    public static final AutomobileFrame EMPTY = REGISTRY.register(new AutomobileFrame(Automobility.rl("empty"), 0.25f, new FrameModel(new ResourceLocation("empty"), Automobility.rl("empty"), WheelBase.basic(16.0f, 16.0f), 16.0f, 8.0f, 8.0f, 4.0f, 8.0f, 8.0f)));
    public static final AutomobileFrame WOODEN_MOTORCAR = REGISTRY.register(AutomobileFrame.motorcar("wooden", 0.3f));
    public static final AutomobileFrame COPPER_MOTORCAR = REGISTRY.register(AutomobileFrame.motorcar("copper", 0.4f));
    public static final AutomobileFrame STEEL_MOTORCAR = REGISTRY.register(AutomobileFrame.motorcar("steel", 0.475f));
    public static final AutomobileFrame GOLDEN_MOTORCAR = REGISTRY.register(AutomobileFrame.motorcar("golden", 0.525f));
    public static final AutomobileFrame BEJEWELED_MOTORCAR = REGISTRY.register(AutomobileFrame.motorcar("bejeweled", 0.555f));
    public static final AutomobileFrame STANDARD_WHITE = REGISTRY.register(AutomobileFrame.standard("white"));
    public static final AutomobileFrame STANDARD_ORANGE = REGISTRY.register(AutomobileFrame.standard("orange"));
    public static final AutomobileFrame STANDARD_MAGENTA = REGISTRY.register(AutomobileFrame.standard("magenta"));
    public static final AutomobileFrame STANDARD_LIGHT_BLUE = REGISTRY.register(AutomobileFrame.standard("light_blue"));
    public static final AutomobileFrame STANDARD_YELLOW = REGISTRY.register(AutomobileFrame.standard("yellow"));
    public static final AutomobileFrame STANDARD_LIME = REGISTRY.register(AutomobileFrame.standard("lime"));
    public static final AutomobileFrame STANDARD_PINK = REGISTRY.register(AutomobileFrame.standard("pink"));
    public static final AutomobileFrame STANDARD_GRAY = REGISTRY.register(AutomobileFrame.standard("gray"));
    public static final AutomobileFrame STANDARD_LIGHT_GRAY = REGISTRY.register(AutomobileFrame.standard("light_gray"));
    public static final AutomobileFrame STANDARD_CYAN = REGISTRY.register(AutomobileFrame.standard("cyan"));
    public static final AutomobileFrame STANDARD_PURPLE = REGISTRY.register(AutomobileFrame.standard("purple"));
    public static final AutomobileFrame STANDARD_BLUE = REGISTRY.register(AutomobileFrame.standard("blue"));
    public static final AutomobileFrame STANDARD_BROWN = REGISTRY.register(AutomobileFrame.standard("brown"));
    public static final AutomobileFrame STANDARD_GREEN = REGISTRY.register(AutomobileFrame.standard("green"));
    public static final AutomobileFrame STANDARD_RED = REGISTRY.register(AutomobileFrame.standard("red"));
    public static final AutomobileFrame STANDARD_BLACK = REGISTRY.register(AutomobileFrame.standard("black"));
    public static final AutomobileFrame AMETHYST_RICKSHAW = REGISTRY.register(AutomobileFrame.rickshaw("amethyst", 0.2f));
    public static final AutomobileFrame QUARTZ_RICKSHAW = REGISTRY.register(AutomobileFrame.rickshaw("quartz", 0.25f));
    public static final AutomobileFrame PRISMARINE_RICKSHAW = REGISTRY.register(AutomobileFrame.rickshaw("prismarine", 0.14f));
    public static final AutomobileFrame ECHO_RICKSHAW = REGISTRY.register(AutomobileFrame.rickshaw("echo", 0.1f));
    public static final AutomobileFrame RED_TRACTOR = REGISTRY.register(AutomobileFrame.tractor("red"));
    public static final AutomobileFrame YELLOW_TRACTOR = REGISTRY.register(AutomobileFrame.tractor("yellow"));
    public static final AutomobileFrame GREEN_TRACTOR = REGISTRY.register(AutomobileFrame.tractor("green"));
    public static final AutomobileFrame BLUE_TRACTOR = REGISTRY.register(AutomobileFrame.tractor("blue"));
    public static final AutomobileFrame SHOPPING_CART = REGISTRY.register(new AutomobileFrame(Automobility.rl("shopping_cart"), 0.25f, new FrameModel(Automobility.rl("textures/entity/automobile/frame/shopping_cart.png"), Automobility.rl("frame_shopping_cart"), WheelBase.basic(17.0f, 12.05f), 25.0f, 11.0f, 7.0f, 17.0f, 11.0f, 11.0f)));
    public static final AutomobileFrame C_ARR = REGISTRY.register(new AutomobileFrame(Automobility.rl("c_arr"), 0.85f, new FrameModel(Automobility.rl("textures/entity/automobile/frame/c_arr.png"), Automobility.rl("frame_c_arr"), WheelBase.basic(44.5f, 16.0f), 44.0f, 6.0f, 19.5f, 10.5f, 23.0f, 23.0f)));
    public static final AutomobileFrame PINEAPPLE = REGISTRY.register(new AutomobileFrame(Automobility.rl("pineapple"), 0.75f, new FrameModel(Automobility.rl("textures/entity/automobile/frame/pineapple.png"), Automobility.rl("frame_pineapple"), WheelBase.basic(10.0f, 18.0f), 20.0f, 16.0f, 8.0f, 6.0f, 9.0f, 9.0f)));
    public static final DisplayStat<AutomobileFrame> STAT_WEIGHT = new DisplayStat<AutomobileFrame>("weight", AutomobileFrame::weight);

    private static AutomobileFrame standard(String color) {
        return new AutomobileFrame(Automobility.rl("standard_" + color), 0.6f, new FrameModel(Automobility.rl("textures/entity/automobile/frame/standard_" + color + ".png"), Automobility.rl("frame_standard"), WheelBase.basic(26.0f, 10.0f), 26.0f, 5.0f, 13.0f, 3.0f, 18.0f, 22.0f));
    }

    private static AutomobileFrame motorcar(String variant, float weight) {
        return new AutomobileFrame(Automobility.rl(variant + "_motorcar"), weight, new FrameModel(Automobility.rl("textures/entity/automobile/frame/" + variant + "_motorcar.png"), Automobility.rl("frame_motorcar"), WheelBase.basic(32.0f, 12.0f), 28.0f, 3.0f, 18.0f, 2.0f, 23.0f, 22.0f));
    }

    private static AutomobileFrame tractor(String color) {
        return new AutomobileFrame(Automobility.rl(color + "_tractor"), 0.9f, new FrameModel(Automobility.rl("textures/entity/automobile/frame/" + color + "_tractor.png"), Automobility.rl("frame_tractor"), new WheelBase(new WheelBase.WheelPos(-2.0f, -7.0f, 1.8f, 0.0f, WheelBase.WheelEnd.BACK, WheelBase.WheelSide.LEFT), new WheelBase.WheelPos(-2.0f, 7.0f, 1.8f, 180.0f, WheelBase.WheelEnd.BACK, WheelBase.WheelSide.RIGHT), new WheelBase.WheelPos(15.0f, -1.0f, 1.0f, 0.0f, WheelBase.WheelEnd.FRONT, WheelBase.WheelSide.LEFT), new WheelBase.WheelPos(15.0f, 1.0f, 1.0f, 180.0f, WheelBase.WheelEnd.FRONT, WheelBase.WheelSide.RIGHT)), 24.0f, 9.0f, 9.0f, 8.0f, 12.0f, 19.0f));
    }

    private static AutomobileFrame rickshaw(String prefix, float weight) {
        return new AutomobileFrame(Automobility.rl(prefix + "_rickshaw"), weight, new FrameModel(Automobility.rl("textures/entity/automobile/frame/" + prefix + "_rickshaw.png"), Automobility.rl("frame_rickshaw"), new WheelBase(new WheelBase.WheelPos(-11.0f, -7.5f, 1.0f, 0.0f, WheelBase.WheelEnd.BACK, WheelBase.WheelSide.LEFT), new WheelBase.WheelPos(-11.0f, 7.5f, 1.0f, 180.0f, WheelBase.WheelEnd.BACK, WheelBase.WheelSide.RIGHT), new WheelBase.WheelPos(11.0f, -0.1f, 1.0f, 0.0f, WheelBase.WheelEnd.FRONT, WheelBase.WheelSide.LEFT), new WheelBase.WheelPos(11.0f, 0.1f, 1.0f, 180.0f, WheelBase.WheelEnd.FRONT, WheelBase.WheelSide.RIGHT)), 26.0f, 2.5f, 13.0f, 3.0f, 17.5f, 14.5f));
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY;
    }

    @Override
    public ResourceLocation containerId() {
        return ID;
    }

    @Override
    public void forEachStat(Consumer<DisplayStat<AutomobileFrame>> action) {
        action.accept(STAT_WEIGHT);
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    public String getTranslationKey() {
        return "frame." + this.id.m_135827_() + "." + this.id.m_135815_();
    }

    public record FrameModel(ResourceLocation texture, ResourceLocation modelId, WheelBase wheelBase, float lengthPx, float seatHeight, float enginePosBack, float enginePosUp, float rearAttachmentPos, float frontAttachmentPos) {
    }
}

