/*
 * Decompiled with CFR 0.152.
 */
package dev.smolinacadena.appliedcooking.blockentity;

import appeng.api.implementations.blockentities.IWirelessAccessPoint;
import appeng.api.networking.IGrid;
import appeng.api.networking.security.IActionHost;
import appeng.api.storage.MEStorage;
import appeng.util.Platform;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import dev.smolinacadena.appliedcooking.AppliedCookingBlockEntities;
import dev.smolinacadena.appliedcooking.AppliedCookingBlocks;
import dev.smolinacadena.appliedcooking.api.cookingforblockheads.capability.KitchenItemProvider;
import dev.smolinacadena.appliedcooking.block.KitchenStationBlock;
import java.util.List;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class KitchenStationBlockEntity
extends BalmBlockEntity {
    private final KitchenItemProvider itemProvider = new KitchenItemProvider(this);
    private GlobalPos accessPointPos = null;
    private IActionHost actionHost = null;
    private IGrid grid = null;
    private MEStorage meStorage = null;

    public KitchenStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AppliedCookingBlockEntities.KITCHEN_STATION.get(), pos, state);
    }

    public List<BalmProvider<?>> getProviders() {
        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(IKitchenItemProvider.class, (Object)this.itemProvider)});
    }

    public void setConnected(boolean connected) {
        this.f_58857_.m_7696_(this.f_58858_, (Block)AppliedCookingBlocks.KITCHEN_STATION.get(), 0, 0);
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)KitchenStationBlock.CONNECTED, (Comparable)Boolean.valueOf(connected)));
        this.m_6596_();
    }

    public void applyDataFromItemToBlockEntity(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("accessPointPos", 10)) {
            this.accessPointPos = GlobalPos.f_122633_.decode((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("accessPointPos")).result().map(Pair::getFirst).orElse(null);
            this.setNetworkProperties();
        } else {
            this.accessPointPos = null;
        }
        this.m_6596_();
    }

    public void applyDataFromBlockEntityToItem(ItemStack stack) {
        if (this.accessPointPos != null) {
            GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.accessPointPos).result().ifPresent(tagValue -> stack.m_41784_().m_128365_("accessPointPos", tagValue));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.accessPointPos != null) {
            GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.accessPointPos).result().ifPresent(tagValue -> tag.m_128365_("accessPointPos", tagValue));
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("accessPointPos")) {
            this.accessPointPos = GlobalPos.f_122633_.decode((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("accessPointPos")).result().map(Pair::getFirst).orElse(null);
        }
    }

    public MEStorage getNetworkStorage() {
        return this.meStorage;
    }

    public String getAccessPointPos() {
        if (this.actionHost != null) {
            return this.accessPointPos.m_122646_().m_123341_() + ", " + this.accessPointPos.m_122646_().m_123342_() + ", " + this.accessPointPos.m_122646_().m_123343_();
        }
        return "";
    }

    public IActionHost getActionHost() {
        return this.actionHost;
    }

    @Nullable
    public void setNetworkProperties() {
        this.actionHost = null;
        this.grid = null;
        this.meStorage = null;
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.accessPointPos == null) {
            return;
        }
        ServerLevel linkedLevel = serverLevel.m_7654_().m_129880_(this.accessPointPos.m_122640_());
        if (linkedLevel == null) {
            return;
        }
        BlockEntity accessPointBlockEntity = Platform.getTickingBlockEntity((Level)linkedLevel, (BlockPos)this.accessPointPos.m_122646_());
        if (!(accessPointBlockEntity instanceof IWirelessAccessPoint)) {
            return;
        }
        IWirelessAccessPoint accessPoint = (IWirelessAccessPoint)accessPointBlockEntity;
        this.actionHost = accessPoint;
        if (accessPoint.isActive()) {
            this.grid = accessPoint.getGrid();
            if (this.grid != null) {
                this.meStorage = this.grid.getStorageService().getInventory();
            }
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, KitchenStationBlockEntity blockEntity) {
        blockEntity.serverTick();
    }

    public void serverTick() {
        this.setNetworkProperties();
        this.setConnected(this.grid != null);
    }
}

