/*
 * Decompiled with CFR 0.152.
 */
package us.maxpowa.apc;

import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;

@Mod(value="apotheoticcreation")
public class ApotheoticCreation {
    public static final ResourceLocation RARITY_ID = new ResourceLocation("apotheoticcreation", "rarity");
    public static final ResourceLocation AFFIX_ID = new ResourceLocation("apotheoticcreation", "affix");

    public ApotheoticCreation() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::registerAttributes);
    }

    private void registerAttributes(RegisterEvent event) {
        ResourceKey attributeRegistryKey = ResourceKey.m_135788_((ResourceLocation)CreateBuiltInRegistries.ITEM_ATTRIBUTE_TYPE.m_123023_().m_135782_());
        if (event.getRegistryKey().equals((Object)attributeRegistryKey)) {
            event.register(attributeRegistryKey, RARITY_ID, RarityAttribute.Type::new);
            event.register(attributeRegistryKey, AFFIX_ID, AffixAttribute.Type::new);
        }
    }

    public static class AffixAttribute
    implements ItemAttribute {
        private static final Set<String> HIDDEN_AFFIXES = Set.of("socket", "durable");
        private DynamicHolder<? extends Affix> affix;

        public AffixAttribute() {
        }

        public AffixAttribute(DynamicHolder<? extends Affix> affix) {
            this.affix = affix;
        }

        public boolean appliesTo(ItemStack stack, Level level) {
            if (this.affix == null || !this.affix.isBound()) {
                return false;
            }
            Map affixes = AffixHelper.getAffixes((ItemStack)stack);
            return affixes.containsKey(this.affix);
        }

        public String getTranslationKey() {
            return "item_affix";
        }

        public Object[] getTranslationParameters() {
            Object[] objectArray;
            if (this.affix != null && this.affix.isBound()) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = Component.m_237115_((String)("affix." + String.valueOf(this.affix.getId())));
            } else {
                objectArray = new Object[]{};
            }
            return objectArray;
        }

        public void save(CompoundTag nbt) {
            if (this.affix != null && this.affix.isBound()) {
                ResourceLocation id = this.affix.getId();
                nbt.m_128359_("namespace", id.m_135827_());
                nbt.m_128359_("path", id.m_135815_());
            }
        }

        public void load(CompoundTag nbt) {
            if (nbt.m_128441_("namespace") && nbt.m_128441_("path")) {
                ResourceLocation id = new ResourceLocation(nbt.m_128461_("namespace"), nbt.m_128461_("path"));
                this.affix = AffixRegistry.INSTANCE.holder(id);
            }
        }

        public ItemAttributeType getType() {
            return (ItemAttributeType)CreateBuiltInRegistries.ITEM_ATTRIBUTE_TYPE.m_7745_(AFFIX_ID);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AffixAttribute)) {
                return false;
            }
            AffixAttribute other = (AffixAttribute)obj;
            return Objects.equals(this.affix, other.affix);
        }

        public int hashCode() {
            return Objects.hashCode(this.affix);
        }

        public static class Type
        implements ItemAttributeType {
            @NotNull
            public ItemAttribute createAttribute() {
                return new AffixAttribute();
            }

            public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
                return AffixHelper.getAffixes((ItemStack)stack).keySet().stream().filter(affix -> affix.isBound() && !HIDDEN_AFFIXES.contains(affix.getId().m_135815_())).map(AffixAttribute::new).collect(Collectors.toList());
            }
        }
    }

    public static class RarityAttribute
    implements ItemAttribute {
        private LootRarity rarity;

        public RarityAttribute() {
        }

        public RarityAttribute(LootRarity rarity) {
            this.rarity = rarity;
        }

        public boolean appliesTo(ItemStack stack, Level level) {
            if (this.rarity == null) {
                return false;
            }
            DynamicHolder itemRarity = AffixHelper.getRarity((ItemStack)stack);
            return itemRarity.isBound() && itemRarity.get() == this.rarity;
        }

        public String getTranslationKey() {
            return "item_rarity";
        }

        public Object[] getTranslationParameters() {
            Object[] objectArray;
            if (this.rarity != null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.rarity.toComponent();
            } else {
                objectArray = new Object[]{};
            }
            return objectArray;
        }

        public void save(CompoundTag nbt) {
            if (this.rarity != null) {
                nbt.m_128405_("rarity", this.rarity.ordinal());
            }
        }

        public void load(CompoundTag nbt) {
            DynamicHolder holder;
            if (nbt.m_128441_("rarity") && (holder = RarityRegistry.byOrdinal((int)nbt.m_128451_("rarity"))).isBound()) {
                this.rarity = (LootRarity)holder.get();
            }
        }

        public ItemAttributeType getType() {
            return (ItemAttributeType)CreateBuiltInRegistries.ITEM_ATTRIBUTE_TYPE.m_7745_(RARITY_ID);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RarityAttribute)) {
                return false;
            }
            RarityAttribute other = (RarityAttribute)obj;
            return Objects.equals(this.rarity, other.rarity);
        }

        public int hashCode() {
            return Objects.hashCode(this.rarity);
        }

        public static class Type
        implements ItemAttributeType {
            @NotNull
            public ItemAttribute createAttribute() {
                return new RarityAttribute();
            }

            public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
                ArrayList<ItemAttribute> attributes = new ArrayList<ItemAttribute>();
                DynamicHolder itemRarity = AffixHelper.getRarity((ItemStack)stack);
                if (itemRarity.isBound()) {
                    attributes.add(new RarityAttribute((LootRarity)itemRarity.get()));
                }
                return attributes;
            }
        }
    }
}

