/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client.gui;

import java.util.Arrays;
import java.util.Locale;
import net.mehvahdjukaar.amendments.Amendments;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class QuillButton
extends AbstractWidget {
    protected static final ResourceLocation[] textures = (ResourceLocation[])Arrays.stream(QuillType.values()).map(t -> Amendments.res("textures/gui/quill/" + t.name().toLowerCase(Locale.ROOT) + ".png")).toArray(ResourceLocation[]::new);
    private int type = 0;

    public QuillButton(Screen screen) {
        super(screen.f_96543_ / 2 + 70, 20, 48, 144, (Component)Component.m_237119_());
        this.refreshTooltip();
    }

    private void refreshTooltip() {
        this.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)("gui.amendments.quill." + this.getType().name().toLowerCase(Locale.ROOT)))));
    }

    public QuillType getType() {
        return QuillType.values()[this.type];
    }

    public void m_5716_(double mouseX, double mouseY) {
        int length = QuillType.values().length;
        int inc = Screen.m_96638_() ? 1 : -1;
        this.type = (this.type + inc + length) % length;
        this.refreshTooltip();
    }

    public void onClick(double mouseX, double mouseY, int button) {
        int length = QuillType.values().length;
        int inc = button == 0 ? 1 : -1;
        this.type = (this.type + inc + length) % length;
        this.refreshTooltip();
    }

    protected boolean m_7972_(int button) {
        return super.m_7972_(button) || button == 1;
    }

    protected ClientTooltipPositioner m_262860_() {
        return DefaultTooltipPositioner.f_262752_;
    }

    protected void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
        guiGraphics.m_280163_(textures[this.type], this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    public ChatFormatting getChatFormatting() {
        return switch (this.getType().ordinal()) {
            case 2 -> ChatFormatting.BOLD;
            case 4 -> ChatFormatting.STRIKETHROUGH;
            case 1 -> ChatFormatting.ITALIC;
            case 3 -> ChatFormatting.UNDERLINE;
            case 5 -> ChatFormatting.OBFUSCATED;
            default -> ChatFormatting.RESET;
        };
    }

    public static enum QuillType {
        DEFAULT,
        ITALIC,
        BOLD,
        UNDERLINE,
        STRIKETHROUGH,
        OBFUSCATED;

    }
}

