/*
 * Decompiled with CFR 0.152.
 */
package net.devel.Amelet.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public class TotemEffectPacket {
    private final int entityId;
    private final ItemStack totemStack;

    public TotemEffectPacket(int entityId, ItemStack totemStack) {
        this.entityId = entityId;
        this.totemStack = totemStack;
    }

    public static void encode(TotemEffectPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.m_130055_(msg.totemStack);
    }

    public static TotemEffectPacket decode(FriendlyByteBuf buf) {
        return new TotemEffectPacket(buf.readInt(), buf.m_130267_());
    }

    public static void handle(TotemEffectPacket msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (TotemEffectPacket.isClientSide()) {
                TotemEffectPacket.handleClient(msg);
            }
        });
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(TotemEffectPacket msg) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(msg.entityId);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
            Minecraft.m_91087_().f_91061_.m_107332_((Entity)player, (ParticleOptions)ParticleTypes.f_123767_, 30);
        }
        if (entity instanceof LocalPlayer) {
            Minecraft.m_91087_().f_91063_.m_109113_(msg.totemStack);
        }
    }

    private static boolean isClientSide() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }
}

