/*
 * Decompiled with CFR 0.152.
 */
package net.devel.Amelet.network;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.devel.Amelet.Amelet;
import net.devel.Amelet.inventory.BoxData;
import net.devel.Amelet.inventory.SBContainer;
import net.devel.Amelet.item.BoxItem;
import net.devel.Amelet.item.data.BoxTier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class OpenAmulet {
    private final int entityId;

    public OpenAmulet(int entityId) {
        this.entityId = entityId;
    }

    public static void encode(OpenAmulet msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
    }

    public static OpenAmulet decode(FriendlyByteBuf buf) {
        return new OpenAmulet(buf.readInt());
    }

    public static void handle(OpenAmulet msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            NetworkEvent.Context contexts = (NetworkEvent.Context)context.get();
            ServerPlayer playerIn = contexts.getSender();
            if (ModList.get().isLoaded("curios")) {
                Optional equipped = Objects.requireNonNull((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)playerIn).orElse(null)).findFirstCurio(itemStack -> itemStack.m_41720_() instanceof BoxItem);
                if (equipped.isPresent()) {
                    ItemStack backpack = ((SlotResult)equipped.get()).stack();
                    OpenAmulet.openAmulet(backpack, (Player)playerIn);
                } else {
                    for (ItemStack backpack : playerIn.m_150109_().f_35974_) {
                        if (!(backpack.m_41720_() instanceof BoxItem)) continue;
                        OpenAmulet.openAmulet(backpack, (Player)playerIn);
                    }
                }
            } else {
                for (ItemStack backpack : playerIn.m_150109_().f_35974_) {
                    if (!(backpack.m_41720_() instanceof BoxItem)) continue;
                    OpenAmulet.openAmulet(backpack, (Player)playerIn);
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void openAmulet(ItemStack backpack, Player playerIn) {
        InteractionHand handIn = playerIn.m_7655_();
        BoxData data = BoxItem.getData(backpack);
        BoxTier itemTier = ((BoxItem)backpack.m_41720_()).tier;
        UUID uuid = data.getUuid();
        data.updateAccessRecords(playerIn.m_7755_().getString(), System.currentTimeMillis());
        if (data.getTier().ordinal() < itemTier.ordinal()) {
            data.upgrade(itemTier);
            playerIn.m_213846_((Component)Component.m_237113_((String)("Backpack upgraded to " + itemTier.name)));
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new SBContainer(windowId, playerInventory, uuid, data.getTier(), OpenAmulet.getSlotIdForHand(playerIn, handIn), data.getHandler()), backpack.m_41786_()), friendlyByteBuf -> friendlyByteBuf.m_130077_(uuid).m_130130_(OpenAmulet.getSlotIdForHand(playerIn, handIn)).writeInt(data.getTier().ordinal()));
    }

    public static int getSlotIdForHand(Player player, InteractionHand hand) {
        int slotId;
        if (hand == InteractionHand.MAIN_HAND) {
            slotId = player.m_150109_().f_35977_;
            if (!Inventory.m_36045_((int)slotId)) {
                Amelet.LOGGER.error("Unable to find main hand slot for player {}", (Object)player.m_36316_().getName());
            }
        } else {
            slotId = 40;
        }
        return slotId;
    }

    private static boolean isClientSide() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }
}

