/*
 * Decompiled with CFR 0.152.
 */
package net.devel.Amelet.item;

import java.util.UUID;
import net.devel.Amelet.Amelet;
import net.devel.Amelet.inventory.BoxData;
import net.devel.Amelet.inventory.BoxManager;
import net.devel.Amelet.inventory.SBContainer;
import net.devel.Amelet.item.data.BoxTier;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoxItem
extends Item {
    public static final int CONTAINER_SIZE = 27;
    final String name;
    public final BoxTier tier;
    public boolean curios = true;

    public BoxItem(String name, BoxTier tier) {
        super(new Item.Properties().m_41487_(1).m_41486_().m_41497_(tier.rarity));
        this.name = name;
        this.tier = tier;
    }

    public static BoxTier getTier(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof BoxItem) {
            return ((BoxItem)stack.m_41720_()).tier;
        }
        return BoxTier.Normal;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (!level.f_46443_ && player instanceof ServerPlayer && stack.m_41720_() instanceof BoxItem) {
            BoxData data = BoxItem.getData(stack);
            BoxTier itemTier = ((BoxItem)stack.m_41720_()).tier;
            UUID uuid = data.getUuid();
            data.updateAccessRecords(player.m_7755_().getString(), System.currentTimeMillis());
            if (data.getTier().ordinal() < itemTier.ordinal()) {
                data.upgrade(itemTier);
                player.m_213846_((Component)Component.m_237113_((String)("Backpack upgraded to " + itemTier.name)));
            }
            if (!player.m_6144_()) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new SBContainer(windowId, playerInventory, uuid, data.getTier(), BoxItem.getSlotIdForHand(player, usedHand), data.getHandler()), stack.m_41786_()), friendlyByteBuf -> friendlyByteBuf.m_130077_(uuid).m_130130_(BoxItem.getSlotIdForHand(player, usedHand)).writeInt(data.getTier().ordinal()));
            }
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(usedHand));
    }

    public static int getSlotIdForHand(Player player, InteractionHand hand) {
        int slotId;
        if (hand == InteractionHand.MAIN_HAND) {
            slotId = player.m_150109_().f_35977_;
            if (!Inventory.m_36045_((int)slotId)) {
                Amelet.LOGGER.error("Unable to find main hand slot for player {}", (Object)player.m_36316_().getName());
            }
        } else {
            slotId = 40;
        }
        return slotId;
    }

    public static BoxData getData(ItemStack stack) {
        UUID uuid;
        if (!(stack.m_41720_() instanceof BoxItem)) {
            return null;
        }
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("UUID")) {
            uuid = UUID.randomUUID();
            tag.m_128362_("UUID", uuid);
        } else {
            uuid = tag.m_128342_("UUID");
        }
        return BoxManager.get().getOrCreateBackpack(uuid, ((BoxItem)stack.m_41720_()).tier);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @javax.annotation.Nullable CompoundTag nbt) {
        return new BoxItemCaps(stack);
    }

    static class BoxItemCaps
    implements ICapabilityProvider {
        private final ItemStack stack;
        private LazyOptional<IItemHandler> optional = LazyOptional.empty();

        public BoxItemCaps(ItemStack stack) {
            this.stack = stack;
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == ForgeCapabilities.ITEM_HANDLER) {
                if (!this.optional.isPresent()) {
                    this.optional = BoxManager.get().getCapability(this.stack);
                }
                return this.optional.cast();
            }
            return LazyOptional.empty();
        }
    }
}

