/*
 * Decompiled with CFR 0.152.
 */
package net.devel.Amelet.inventory;

import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import net.devel.Amelet.inventory.BoxData;
import net.devel.Amelet.item.data.BoxTier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class BoxManager
extends SavedData {
    private static final String NAME = "ameletAmulete_data";
    private static final HashMap<UUID, BoxData> data = new HashMap();
    public static final BoxManager blankClient = new BoxManager();

    public HashMap<UUID, BoxData> getMap() {
        return data;
    }

    public static BoxManager get() {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            return (BoxManager)ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_).m_8895_().m_164861_(BoxManager::load, BoxManager::new, NAME);
        }
        return blankClient;
    }

    public static BoxManager load(CompoundTag nbt) {
        if (nbt.m_128441_("inve")) {
            ListTag list = nbt.m_128437_("inve", 10);
            list.forEach(backpackNBT -> BoxData.fromNBT((CompoundTag)backpackNBT).ifPresent(backpack -> data.put(backpack.getUuid(), (BoxData)backpack)));
        }
        return new BoxManager();
    }

    public Optional<BoxData> getBackpack(UUID uuid) {
        if (data.containsKey(uuid)) {
            return Optional.of(data.get(uuid));
        }
        return Optional.empty();
    }

    public LazyOptional<IItemHandler> getCapability(ItemStack stack) {
        UUID uuid;
        if (stack.m_41784_().m_128441_("UUID") && data.containsKey(uuid = stack.m_41783_().m_128342_("UUID"))) {
            return data.get(uuid).getOptional();
        }
        return LazyOptional.empty();
    }

    public BoxData getOrCreateBackpack(UUID uuid, BoxTier tier) {
        return data.computeIfAbsent(uuid, id -> {
            this.m_77762_();
            return new BoxData((UUID)id, tier);
        });
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag backpacks = new ListTag();
        data.forEach((uuid, backpackData) -> backpacks.add((Object)backpackData.toNBT()));
        compound.m_128365_("inve", (Tag)backpacks);
        return compound;
    }
}

