/*
 * Decompiled with CFR 0.152.
 */
package net.devel.Amelet.client;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.devel.Amelet.client.ClientStuff;
import net.devel.Amelet.inventory.BoxData;
import net.devel.Amelet.item.BoxItem;
import net.devel.Amelet.item.XTotem;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@Mod.EventBusSubscriber(modid="amelet")
public class Events {
    @SubscribeEvent
    public static void onPlayerDeathEvent(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (ModList.get().isLoaded("curios")) {
                Optional firstCurio = Objects.requireNonNull((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).orElse(null)).findFirstCurio(itemStack -> itemStack.m_41720_() instanceof BoxItem);
                if (firstCurio.isPresent()) {
                    BoxData data = BoxItem.getData(((SlotResult)firstCurio.get()).stack());
                    IItemHandler handler = data.getHandler();
                    if (!Events.containsTotems(handler)) {
                        Events.searchInventoryForTotems(player, event);
                    } else {
                        Events.consumeTotemFromHandler(handler, player, event);
                    }
                } else {
                    Events.searchInventoryForTotems(player, event);
                }
            } else {
                Events.searchInventoryForTotems(player, event);
            }
        }
    }

    @SubscribeEvent
    public static void addCustomWanderingTrades(WandererTradesEvent event) {
        List genericTrades = event.getGenericTrades();
        List rareTrades = event.getRareTrades();
        rareTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 64), new ItemStack((ItemLike)Items.f_42748_, 3), 1, 2, 0.2f));
    }

    private static boolean consumeTotemFromHandler(IItemHandler handler, ServerPlayer player, LivingDeathEvent event) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack slotStack = handler.getStackInSlot(i);
            if (slotStack.m_41720_() == Items.f_42747_) {
                ClientStuff.totemVanilla(slotStack, player, event);
                slotStack.m_41774_(1);
                return true;
            }
            if (!(slotStack.m_41720_() instanceof XTotem)) continue;
            ClientStuff.totemXTotem(slotStack, player, event);
            slotStack.m_41774_(1);
            return true;
        }
        return false;
    }

    private static boolean searchInventoryForTotems(ServerPlayer player, LivingDeathEvent event) {
        for (ItemStack itemStack : player.m_150109_().f_35974_) {
            BoxData data;
            IItemHandler handler;
            if (!(itemStack.m_41720_() instanceof BoxItem) || !Events.consumeTotemFromHandler(handler = (data = BoxItem.getData(itemStack)).getHandler(), player, event)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsTotems(IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack slotStack = handler.getStackInSlot(i);
            if (slotStack.m_41720_() != Items.f_42747_ && !(slotStack.m_41720_() instanceof XTotem)) continue;
            return true;
        }
        return false;
    }
}

