/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.block.reactor;

import com.smashingmods.alchemistry.common.block.reactor.ReactorBlockEntity;
import com.smashingmods.alchemistry.common.block.reactor.ReactorCoreBlock;
import com.smashingmods.alchemistry.common.block.reactor.ReactorEnergyBlockEntity;
import com.smashingmods.alchemistry.common.block.reactor.ReactorInputBlockEntity;
import com.smashingmods.alchemistry.common.block.reactor.ReactorOutputBlockEntity;
import com.smashingmods.alchemistry.common.block.reactor.ReactorShape;
import com.smashingmods.alchemistry.common.block.reactor.ReactorType;
import com.smashingmods.alchemistry.registry.BlockRegistry;
import com.smashingmods.alchemylib.api.block.AbstractProcessingBlock;
import com.smashingmods.alchemylib.api.blockentity.power.PowerState;
import com.smashingmods.alchemylib.api.blockentity.power.PowerStateProperty;
import com.smashingmods.alchemylib.api.blockentity.processing.AbstractInventoryBlockEntity;
import com.smashingmods.alchemylib.api.storage.ProcessingSlotHandler;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.joml.Vector3f;

public abstract class AbstractReactorBlockEntity
extends AbstractInventoryBlockEntity
implements ReactorBlockEntity {
    private ReactorShape reactorShape;
    private ReactorType reactorType;
    private ReactorEnergyBlockEntity reactorEnergyBlockEntity;
    private ReactorInputBlockEntity reactorInputBlockEntity;
    private ReactorOutputBlockEntity reactorOutputBlockEntity;
    private boolean energyFound;
    private boolean inputFound;
    private boolean outputFound;
    private boolean autoeject = false;

    public AbstractReactorBlockEntity(BlockEntityType<?> pBlockEntityType, BlockPos pWorldPosition, BlockState pBlockState) {
        super("alchemistry", pBlockEntityType, pWorldPosition, pBlockState);
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            if (this.reactorShape == null) {
                this.setReactorShape(new ReactorShape(this.m_58899_(), this.getReactorType(), this.f_58857_));
            }
            this.setMultiblockHandlers();
            if (this.isValidMultiblock()) {
                switch (this.getPowerState()) {
                    case ON: {
                        if (this.isProcessingPaused()) break;
                        BlockPos coreCenter = this.reactorShape.getCoreBoundingBox().m_162394_();
                        DustParticleOptions options = new DustParticleOptions(new Vector3f(1.0f, 1.0f, 0.5f), 0.15f);
                        ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)options, (double)coreCenter.m_123341_(), (double)coreCenter.m_123342_(), (double)coreCenter.m_123343_(), 50, 1.5, 1.5, 1.5, 0.0);
                        break;
                    }
                    case OFF: 
                    case DISABLED: {
                        if (this.getEnergyHandler().getEnergyStored() > this.getEnergyPerTick()) {
                            this.setPowerState(PowerState.STANDBY);
                            break;
                        }
                        this.setPowerState(PowerState.OFF);
                    }
                }
                if (!this.isProcessingPaused()) {
                    if (!this.getInputHandler().isEmpty()) {
                        this.updateRecipe();
                    }
                    if (this.canProcessRecipe()) {
                        this.setPowerState(PowerState.ON);
                        this.processRecipe();
                    } else if (this.getEnergyHandler().getEnergyStored() > this.getEnergyPerTick()) {
                        this.setPowerState(PowerState.STANDBY);
                    } else {
                        this.setPowerState(PowerState.OFF);
                    }
                } else if (this.getPowerState().equals((Object)PowerState.ON)) {
                    this.setPowerState(PowerState.STANDBY);
                }
                if (this.isAutoEject()) {
                    this.tryEjectOutputs();
                }
            } else {
                this.setPowerState(PowerState.DISABLED);
            }
        }
    }

    @Override
    public ReactorShape getReactorShape() {
        return this.reactorShape;
    }

    @Override
    public void setReactorShape(ReactorShape reactorShape) {
        this.reactorShape = reactorShape;
    }

    @Override
    public ReactorType getReactorType() {
        return this.reactorType;
    }

    @Override
    public void setReactorType(ReactorType pReactorType) {
        this.reactorType = pReactorType;
    }

    @Override
    public void setMultiblockHandlers() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            BoundingBox reactorBox = this.getReactorShape().getFullBoundingBox();
            if (this.reactorEnergyBlockEntity == null || !this.energyFound) {
                BlockPos.m_121919_((BoundingBox)reactorBox).filter(blockPos -> this.f_58857_.m_7702_(blockPos) instanceof ReactorEnergyBlockEntity).findFirst().ifPresent(blockPos -> {
                    this.setEnergyFound(true);
                    this.reactorEnergyBlockEntity = (ReactorEnergyBlockEntity)this.f_58857_.m_7702_(blockPos);
                    if (this.reactorEnergyBlockEntity != null) {
                        this.reactorEnergyBlockEntity.setController(this);
                    }
                    this.f_58857_.m_46672_(blockPos, (Block)BlockRegistry.REACTOR_ENERGY.get());
                });
            } else {
                this.reactorEnergyBlockEntity.setController(this);
            }
            if (this.reactorInputBlockEntity == null || !this.inputFound) {
                BlockPos.m_121919_((BoundingBox)reactorBox).filter(blockPos -> this.f_58857_.m_7702_(blockPos) instanceof ReactorInputBlockEntity).findFirst().ifPresent(blockPos -> {
                    this.inputFound = true;
                    this.reactorInputBlockEntity = (ReactorInputBlockEntity)this.f_58857_.m_7702_(blockPos);
                    if (this.reactorInputBlockEntity != null) {
                        this.reactorInputBlockEntity.setController(this);
                    }
                    this.f_58857_.m_46672_(blockPos, (Block)BlockRegistry.REACTOR_INPUT.get());
                });
            } else {
                this.reactorInputBlockEntity.setController(this);
            }
            if (this.reactorOutputBlockEntity == null || !this.outputFound) {
                this.outputFound = false;
                BlockPos.m_121919_((BoundingBox)reactorBox).filter(blockPos -> this.f_58857_.m_7702_(blockPos) instanceof ReactorOutputBlockEntity).findFirst().ifPresent(blockPos -> {
                    this.outputFound = true;
                    this.reactorOutputBlockEntity = (ReactorOutputBlockEntity)this.f_58857_.m_7702_(blockPos);
                    if (this.reactorOutputBlockEntity != null) {
                        this.reactorOutputBlockEntity.setController(this);
                    }
                    this.f_58857_.m_46672_(blockPos, (Block)BlockRegistry.REACTOR_OUTPUT.get());
                });
            } else {
                this.reactorOutputBlockEntity.setController(this);
            }
        }
    }

    @Override
    public PowerState getPowerState() {
        return (PowerState)this.m_58900_().m_61143_((Property)PowerStateProperty.POWER_STATE);
    }

    @Override
    public void setPowerState(PowerState pPowerState) {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)PowerStateProperty.POWER_STATE, (Comparable)pPowerState));
        }
    }

    public void setEnergyFound(boolean pEnergyFound) {
        this.energyFound = pEnergyFound;
    }

    public void setInputFound(boolean pInputFound) {
        this.inputFound = pInputFound;
    }

    public void setOutputFound(boolean pOutputFound) {
        this.outputFound = pOutputFound;
    }

    public void setAutoeject(boolean autoeject) {
        this.autoeject = autoeject;
    }

    @Override
    public boolean isValidMultiblock() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            Consumer<BlockPos> handleCorePowerState = blockPos -> {
                BlockState blockState;
                if (this.f_58857_ != null && !this.f_58857_.m_5776_() && (blockState = this.f_58857_.m_8055_(blockPos)).m_60734_() instanceof ReactorCoreBlock) {
                    PowerState coreState = (PowerState)blockState.m_61143_((Property)PowerStateProperty.POWER_STATE);
                    switch (this.getPowerState()) {
                        case OFF: 
                        case DISABLED: {
                            if (!coreState.equals((Object)PowerState.ON)) break;
                            BlockState newState = (BlockState)blockState.m_61124_((Property)PowerStateProperty.POWER_STATE, (Comparable)PowerState.OFF);
                            this.f_58857_.m_7731_(blockPos, newState, 7);
                            break;
                        }
                        case ON: 
                        case STANDBY: {
                            if (!coreState.equals((Object)PowerState.OFF)) break;
                            BlockState newState = (BlockState)blockState.m_61124_((Property)PowerStateProperty.POWER_STATE, (Comparable)PowerState.ON);
                            this.f_58857_.m_7731_(blockPos, newState, 7);
                        }
                    }
                }
            };
            BlockPos.m_121919_((BoundingBox)this.reactorShape.getCoreBoundingBox()).forEach(handleCorePowerState);
            return this.validateMultiblockShape(this.f_58857_, this.getReactorShape().createShapeMap()) && this.energyFound && this.inputFound && this.outputFound;
        }
        return false;
    }

    public void resetIO() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.setMultiblockHandlers();
            if (this.reactorEnergyBlockEntity != null) {
                BlockState energyState = this.reactorEnergyBlockEntity.m_58900_();
                BlockPos energyPos = this.reactorEnergyBlockEntity.m_58899_();
                this.f_58857_.m_46597_(energyPos, Blocks.f_50016_.m_49966_());
                this.f_58857_.m_46597_(energyPos, energyState);
            }
            if (this.reactorInputBlockEntity != null) {
                BlockState inputState = this.reactorInputBlockEntity.m_58900_();
                BlockPos inputPos = this.reactorInputBlockEntity.m_58899_();
                this.f_58857_.m_46597_(inputPos, Blocks.f_50016_.m_49966_());
                this.f_58857_.m_46597_(inputPos, inputState);
            }
            if (this.reactorOutputBlockEntity != null) {
                BlockState outputState = this.reactorOutputBlockEntity.m_58900_();
                BlockPos outputPos = this.reactorOutputBlockEntity.m_58899_();
                this.f_58857_.m_46597_(outputPos, Blocks.f_50016_.m_49966_());
                this.f_58857_.m_46597_(outputPos, outputState);
            }
        }
    }

    public void onRemove() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.resetIO();
            BlockPos.m_121919_((BoundingBox)this.reactorShape.getCoreBoundingBox()).forEach(blockPos -> {
                BlockState blockState = this.f_58857_.m_8055_(blockPos);
                if (blockState.m_60734_() instanceof ReactorCoreBlock) {
                    BlockState offState = (BlockState)blockState.m_61124_((Property)PowerStateProperty.POWER_STATE, (Comparable)PowerState.OFF);
                    this.f_58857_.m_46597_(blockPos, offState);
                }
            });
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        if (this.reactorEnergyBlockEntity != null) {
            pTag.m_128365_("reactorEnergyPos", (Tag)this.blockPosToTag(this.reactorEnergyBlockEntity.m_58899_()));
        }
        if (this.reactorInputBlockEntity != null) {
            pTag.m_128365_("reactorInputPos", (Tag)this.blockPosToTag(this.reactorInputBlockEntity.m_58899_()));
        }
        if (this.reactorOutputBlockEntity != null) {
            pTag.m_128365_("reactorOutputPos", (Tag)this.blockPosToTag(this.reactorOutputBlockEntity.m_58899_()));
        }
        pTag.m_128379_("autoeject", this.autoeject);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            BlockEntity blockEntity;
            BlockEntity blockEntity2 = this.f_58857_.m_7702_(this.blockPosFromTag(pTag.m_128469_("reactorEnergyPos")));
            if (blockEntity2 instanceof ReactorEnergyBlockEntity) {
                blockEntity = (ReactorEnergyBlockEntity)blockEntity2;
                this.reactorEnergyBlockEntity = blockEntity;
                this.energyFound = true;
            } else {
                this.energyFound = false;
            }
            blockEntity2 = this.f_58857_.m_7702_(this.blockPosFromTag(pTag.m_128469_("reactorInputPos")));
            if (blockEntity2 instanceof ReactorInputBlockEntity) {
                blockEntity = (ReactorInputBlockEntity)blockEntity2;
                this.reactorInputBlockEntity = blockEntity;
                this.inputFound = true;
            } else {
                this.inputFound = false;
            }
            blockEntity2 = this.f_58857_.m_7702_(this.blockPosFromTag(pTag.m_128469_("reactorOutputPos")));
            if (blockEntity2 instanceof ReactorOutputBlockEntity) {
                blockEntity = (ReactorOutputBlockEntity)blockEntity2;
                this.reactorOutputBlockEntity = blockEntity;
                this.outputFound = true;
            } else {
                this.outputFound = false;
            }
        }
        this.autoeject = pTag.m_128471_("autoeject");
    }

    private CompoundTag blockPosToTag(BlockPos pBlockPos) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("x", pBlockPos.m_123341_());
        tag.m_128405_("y", pBlockPos.m_123342_());
        tag.m_128405_("z", pBlockPos.m_123343_());
        return tag;
    }

    private BlockPos blockPosFromTag(CompoundTag pTag) {
        return new BlockPos(pTag.m_128451_("x"), pTag.m_128451_("y"), pTag.m_128451_("z"));
    }

    public boolean isAutoEject() {
        return this.autoeject;
    }

    public void tryEjectOutputs() {
        if (this.reactorOutputBlockEntity == null) {
            return;
        }
        Direction outputDirection = (Direction)this.reactorOutputBlockEntity.m_58900_().m_61143_((Property)AbstractProcessingBlock.FACING);
        BlockEntity target = this.f_58857_.m_7702_(this.reactorOutputBlockEntity.m_58899_().m_121945_(outputDirection));
        if (target == null) {
            return;
        }
        IItemHandler targetHandler = (IItemHandler)target.getCapability(ForgeCapabilities.ITEM_HANDLER, outputDirection.m_122424_()).orElse(null);
        if (targetHandler != null) {
            ProcessingSlotHandler outputHandler = this.getOutputHandler();
            for (int i = 0; i < outputHandler.getSlots(); ++i) {
                ItemStack outputStack = outputHandler.getStackInSlot(i);
                if (outputStack.m_41619_()) continue;
                ItemStack remaining = ItemHandlerHelper.insertItem((IItemHandler)targetHandler, (ItemStack)outputStack, (boolean)false);
                if (remaining.m_41613_() == outputStack.m_41613_()) break;
                outputHandler.setStackInSlot(i, remaining);
            }
        }
    }
}

