/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.utils.forge;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.util.ITeleporter;

public class PlatformUtilsImpl {
    public static Entity teleportToDimension(Entity entity, ServerLevel level, PortalInfo portalInfo) {
        return entity.changeDimension(level, (ITeleporter)new AdAstraTeleporter(portalInfo));
    }

    public static Supplier<Item> createSpawnEggItem(Supplier<? extends EntityType<? extends Mob>> type, int primaryColor, int secondaryColor, Item.Properties properties) {
        return () -> new ForgeSpawnEggItem(type, primaryColor, secondaryColor, properties);
    }

    private record AdAstraTeleporter(PortalInfo target) implements ITeleporter
    {
        public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
            return this.target;
        }

        public boolean isVanilla() {
            return false;
        }

        public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
            return false;
        }

        public Entity placeEntity(Entity entity, ServerLevel currentLevel, ServerLevel destLevel, float yaw, Function<Boolean, Entity> repositionEntity) {
            return repositionEntity.apply(false);
        }
    }
}

