/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.data;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tv.soaryn.xycraft.world.content.WorldContent;
import tv.soaryn.xycraft.world.data.WorldBlockLoot;
import tv.soaryn.xycraft.world.data.WorldBlockStateDataGen;
import tv.soaryn.xycraft.world.data.WorldBlockTagDataGen;
import tv.soaryn.xycraft.world.data.WorldItemModelDataGen;
import tv.soaryn.xycraft.world.data.WorldItemTagDataGen;
import tv.soaryn.xycraft.world.data.WorldLanguageDataGen;
import tv.soaryn.xycraft.world.data.WorldRecipeDataGen;

@Mod.EventBusSubscriber(modid="xycraft_world", bus=Mod.EventBusSubscriber.Bus.MOD)
public class WorldDataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookup = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(true, (DataProvider)new WorldRecipeDataGen(output));
        if (event.includeServer()) {
            WorldBlockTagDataGen blockTag = new WorldBlockTagDataGen(output, lookup, "xycraft_world", existingFileHelper);
            generator.addProvider(true, (DataProvider)blockTag);
            generator.addProvider(true, (DataProvider)new WorldItemTagDataGen(output, lookup, blockTag.m_274426_(), "xycraft_world", existingFileHelper));
            generator.addProvider(true, (DataProvider)WorldBlockLoot.supplier(output));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new WorldLanguageDataGen(output, "xycraft_world", "en_us"));
            generator.addProvider(true, (DataProvider)new WorldLanguageDataGen(output, "xycraft_world", "fi_fi"));
            generator.addProvider(true, (DataProvider)new WorldLanguageDataGen(output, "xycraft_world", "en_au"));
            generator.addProvider(true, (DataProvider)new WorldLanguageDataGen(output, "xycraft_world", "en_gb"));
            generator.addProvider(true, (DataProvider)new WorldBlockStateDataGen(output, WorldContent.Map, "xycraft_world", existingFileHelper));
            generator.addProvider(true, (DataProvider)new WorldItemModelDataGen(output, "xycraft_world", existingFileHelper));
        }
    }
}

