/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.blocks;

import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.items.XyBlockItem;
import tv.soaryn.xycraft.core.utils.ColorSource;
import tv.soaryn.xycraft.world.content.WorldContent;

public class AureyBlock
extends ColoredBlock {
    private final DyeColor _dyeColor;

    public AureyBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super((ColorSource)new ColorSource.Dye(color), properties);
        this._dyeColor = color;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EnumMap<DyeColor, BlockContent> getCurrentMap(int light, BlockState state) {
        EnumMap<DyeColor, BlockContent> currentMap;
        EnumMap<DyeColor, BlockContent> enumMap = currentMap = light > 0 ? WorldContent.AureyBlockMatteGlowing : WorldContent.AureyBlockMatte;
        if (light > 0) {
            if (WorldContent.AureyBlockFxGlowing.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).m_60713_(arg_0))) {
                return WorldContent.AureyBlockFxGlowing;
            }
        }
        if (!WorldContent.AureyBlockFx.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).m_60713_(arg_0))) return currentMap;
        return WorldContent.AureyBlockFx;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        if (player.m_7500_()) {
            return super.getCloneItemStack(state, target, level, pos, player);
        }
        EnumMap<DyeColor, BlockContent> currentMap = state.getLightEmission(level, pos) > 0 ? WorldContent.AureyBlockMatteGlowing : WorldContent.AureyBlockMatte;
        return new ItemStack((ItemLike)currentMap.get(DyeColor.PINK).block(), 1);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hit) {
        EnumMap<DyeColor, BlockContent> currentMap;
        BlockContent blockType;
        DyeColor dyeColor;
        InteractionResult interactionResult = ColoredBlock.tryToAllowSpawns((BlockState)state, (Level)level, (BlockPos)pos, (Player)player, (InteractionHand)interactionHand);
        if (interactionResult != InteractionResult.PASS) {
            return interactionResult;
        }
        ItemStack stack = player.m_21120_(interactionHand);
        if (stack.m_41619_() && interactionHand == InteractionHand.MAIN_HAND) {
            boolean wasLight = false;
            EnumMap<DyeColor, BlockContent> map = WorldContent.AureyBlockMatte;
            if (WorldContent.AureyBlockMatte.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).m_60713_(arg_0))) {
                map = WorldContent.AureyBlockFx;
            } else if (WorldContent.AureyBlockMatteGlowing.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).m_60713_(arg_0))) {
                wasLight = true;
                map = player.m_6144_() ? WorldContent.AureyBlockMatte : WorldContent.AureyBlockFxGlowing;
            } else if (WorldContent.AureyBlockFxGlowing.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).m_60713_(arg_0))) {
                wasLight = true;
                EnumMap<DyeColor, BlockContent> enumMap = map = player.m_6144_() ? WorldContent.AureyBlockFx : WorldContent.AureyBlockMatteGlowing;
            }
            if (wasLight && player.m_6144_()) {
                if (!player.m_7500_()) {
                    Block.m_152435_((Level)level, (BlockPos)pos, (Direction)hit.m_82434_(), (ItemStack)new ItemStack((ItemLike)Items.f_151056_));
                }
                level.m_46597_(pos, map.get(this._dyeColor).block().m_152465_(state));
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (!player.m_6144_()) {
                level.m_46597_(pos, map.get(this._dyeColor).block().m_152465_(state));
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        if (stack.m_41720_() == Items.f_151056_) {
            if (WorldContent.AureyBlockMatteGlowing.values().stream().map(BlockContent::block).noneMatch(arg_0 -> ((BlockState)state).m_60713_(arg_0))) {
                if (WorldContent.AureyBlockFxGlowing.values().stream().map(BlockContent::block).noneMatch(arg_0 -> ((BlockState)state).m_60713_(arg_0))) {
                    EnumMap<DyeColor, BlockContent> currentMap2;
                    EnumMap<DyeColor, BlockContent> enumMap = currentMap2 = WorldContent.AureyBlockFx.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).m_60713_(arg_0)) ? WorldContent.AureyBlockFxGlowing : WorldContent.AureyBlockMatteGlowing;
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                    }
                    stack.m_41774_(player.m_7500_() ? 0 : 1);
                    level.m_46597_(pos, currentMap2.get(this._dyeColor).block().m_152465_(state));
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            }
        }
        if ((dyeColor = DyeColor.getColor((ItemStack)stack)) != null && (blockType = (currentMap = this.getCurrentMap(state.getLightEmission((BlockGetter)level, pos), state)).get(dyeColor)).block() != this) {
            level.m_7731_(pos, currentMap.get(dyeColor).block().m_152465_(state), 11);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, interactionHand, hit);
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        Player player = context.m_43723_();
        if (player != null) {
            ItemStack offhandStack = player.m_21206_();
            int light = state.getLightEmission((BlockGetter)context.m_43725_(), context.m_8083_());
            DyeColor color = DyeColor.getColor((ItemStack)offhandStack);
            if (color != null) {
                state = this.getCurrentMap(light, state).get(color).block().m_49966_();
            }
        }
        return (BlockState)state.m_61124_((Property)CoreStateProperties.Spawnable, (Comparable)Boolean.valueOf(false));
    }

    public static Supplier<Block> blockSupplier(DyeColor color) {
        return () -> new AureyBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)WorldContent.AluminumStorage.block()));
    }

    public static Supplier<Block> blockSupplierGlow(DyeColor color) {
        return () -> new AureyBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)WorldContent.AluminumStorage.block()).m_60953_(state -> 15));
    }

    public static Supplier<Item> itemSupplier(DyeColor dyeColor, RegistryObject<Block> blockRegistryObject) {
        return () -> new XyBlockItem((Block)blockRegistryObject.get(), new Item.Properties());
    }

    public static Supplier<Item> itemSupplierHidden(DyeColor dyeColor, RegistryObject<Block> blockRegistryObject) {
        return () -> new XyBlockItem((Block)blockRegistryObject.get(), new Item.Properties());
    }
}

