/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.override;

import java.nio.file.Path;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.resource.PathPackResources;
import tv.soaryn.xycraft.core.content.CompatContent;
import tv.soaryn.xycraft.override.XyOverride;

@Mod.EventBusSubscriber(modid="xycraft_override", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class XyOverrideClient {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onAddPackFinders(AddPackFindersEvent event) {
        try {
            if (event.getPackType() == PackType.CLIENT_RESOURCES) {
                XyOverrideClient.addPack(event, "OverridesStone", "add_xycraft_overrides_stone", "XyCraft Stone Overrides", true);
                XyOverrideClient.addPack(event, "OverridesMetal", "add_xycraft_overrides_metal", "XyCraft Metal Overrides", true);
                XyOverrideClient.addPack(event, "OverridesGlass", "add_xycraft_overrides_glass", "XyCraft Glass Overrides", true);
                XyOverrideClient.addPack(event, "OverridesOptionalMC", "add_xycraft_overrides_optional_mc", "XyCraft Model Overrides", false);
                if (CompatContent.AE2.Mod.isLoaded()) {
                    XyOverrideClient.addPack(event, "OverridesAE2", "add_xycraft_override_ae2", "XyCraft AE2 Overrides", false);
                }
            }
        }
        catch (Exception ex) {
            XyOverride.Logger.error("Resource Pack threw an error! Please report this to the XyCraft issue tracker: https://github.com/Soaryn/XyCraftTracker/issues");
            XyOverride.Logger.error(ex.toString());
        }
    }

    private static void addPack(AddPackFindersEvent event, String pathName, String keyName, String packName, boolean required) {
        Path resourcePath = ModList.get().getModFileById("xycraft_override").getFile().findResource(new String[]{pathName});
        Pack pack = Pack.m_245429_((String)("builtin/" + keyName), (Component)Component.m_237113_((String)packName), (boolean)required, path -> new PathPackResources(path, false, resourcePath), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
        event.addRepositorySource(packConsumer -> packConsumer.accept(pack));
    }
}

