/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import tv.soaryn.xycraft.core.utils.FastVolumeLookup;
import tv.soaryn.xycraft.core.utils.StringUtils;
import tv.soaryn.xycraft.machines.content.MachinesAttributes;
import tv.soaryn.xycraft.machines.content.capabilities.volumes.HoverVolumeCache;

public class HoverPackItem
extends ArmorItem {
    private final Multimap<Attribute, AttributeModifier> _defaultModifiers;
    private static final UUID TakeOffUUID = StringUtils.createUuid((String)"attribute.xycraft.takeoff");
    private static final UUID HoverUUID = StringUtils.createUuid((String)"attribute.xycraft.hover_flight");
    private static final AttributeModifier TakingOff = new AttributeModifier(TakeOffUUID, "Taking off", 0.0, AttributeModifier.Operation.ADDITION);
    private static final ArmorMaterial HoverPackMaterial = new ArmorMaterial(){

        public int m_266425_(@NotNull ArmorItem.Type type) {
            return 0;
        }

        public int m_7366_(@NotNull ArmorItem.Type type) {
            return type != ArmorItem.Type.CHESTPLATE ? 0 : 6;
        }

        public int m_6646_() {
            return 0;
        }

        @NotNull
        public SoundEvent m_7344_() {
            return SoundEvents.f_11680_;
        }

        @NotNull
        public Ingredient m_6230_() {
            return Ingredient.f_43901_;
        }

        @NotNull
        public String m_6082_() {
            return "aluminum_hover_pack";
        }

        public float m_6651_() {
            return 4.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }
    };

    public HoverPackItem() {
        super(HoverPackMaterial, ArmorItem.Type.CHESTPLATE, new Item.Properties().setNoRepair().m_41487_(1).m_246768_(new FeatureFlag[]{FeatureFlags.f_244112_}));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(HoverUUID, "Armor", 2.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(HoverUUID, "Armor toughness", 1.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)MachinesAttributes.HoverFlight.get()), (Object)new AttributeModifier(HoverUUID, "Hover Flight", 1.0, AttributeModifier.Operation.ADDITION));
        this._defaultModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.CHEST) {
            return this._defaultModifiers;
        }
        return ImmutableMultimap.of();
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(HoverPackItem::onEndPlayerTick);
        MinecraftForge.EVENT_BUS.addListener(HoverPackItem::onLivingDamage);
    }

    public static void onLivingDamage(LivingFallEvent event) {
        AttributeInstance hoverFlight = event.getEntity().m_21051_((Attribute)MachinesAttributes.HoverFlight.get());
        if (hoverFlight != null && hoverFlight.m_22135_() > 0.5 && !event.getEntity().m_6144_()) {
            event.setCanceled(true);
        }
    }

    private static void onEndPlayerTick(TickEvent.PlayerTickEvent event) {
        int tickFrequency = 5;
        if (event.side == LogicalSide.CLIENT) {
            tickFrequency = 1;
        }
        if (event.phase != TickEvent.Phase.END || event.player.f_19797_ % tickFrequency != 0 || event.player.m_7500_() || event.player.m_5833_()) {
            return;
        }
        Level level = event.player.m_9236_();
        Abilities abilities = event.player.m_150110_();
        AttributeInstance hoverFlight = event.player.m_21051_((Attribute)MachinesAttributes.HoverFlight.get());
        if (hoverFlight != null && hoverFlight.m_22135_() > 0.5) {
            FastVolumeLookup volumes;
            Optional v;
            if (!hoverFlight.m_22109_(TakingOff)) {
                hoverFlight.m_22118_(TakingOff);
            }
            if ((v = (volumes = FastVolumeLookup.of((Level)level, HoverVolumeCache.HoverVolumeAnchor.class)).find(event.player.m_20183_()).findFirst()).isPresent()) {
                if (!level.m_5776_()) {
                    abilities.f_35936_ = true;
                    event.player.m_6885_();
                }
                if (!event.player.m_6144_()) {
                    event.player.m_183634_();
                }
            } else if (!level.m_5776_()) {
                abilities.f_35936_ = false;
                abilities.f_35935_ = false;
                event.player.m_6885_();
                if (!event.player.m_6144_()) {
                    event.player.m_183634_();
                }
            } else if (!abilities.f_35935_ && !event.player.m_6144_()) {
                event.player.m_183634_();
                Vec3 vec3 = event.player.m_20184_();
                if (vec3.m_7098_() < -0.0) {
                    Vector3f delta = vec3.m_252839_();
                    delta.y = Math.max(delta.y(), -0.3f);
                    event.player.m_20334_((double)delta.x(), (double)delta.y(), (double)delta.z());
                }
            }
        } else if (!level.m_5776_() && hoverFlight != null && hoverFlight.m_22109_(TakingOff)) {
            abilities.f_35936_ = false;
            abilities.f_35935_ = false;
            hoverFlight.m_22130_(TakingOff);
            event.player.m_6885_();
            event.player.m_183634_();
        }
    }
}

