/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.capabilities.volumes;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.capabilities.volumes.AnchoredVolumeCache;
import tv.soaryn.xycraft.machines.config.MachinesConfig;
import tv.soaryn.xycraft.machines.content.MachinesContent;

@AutoRegisterCapability
public class CollectorVolumeCache
extends AnchoredVolumeCache<CollectorVolumeAnchor> {
    public static final Capability<CollectorVolumeCache> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<CollectorVolumeCache>(){});

    public CollectorVolumeCache() {
        super(CollectorVolumeAnchor.class);
    }

    public static CollectorVolumeCache of(Level level) {
        return (CollectorVolumeCache)((Object)level.getCapability(CAPABILITY).orElseThrow(IllegalStateException::new));
    }

    public static void register(AttachCapabilitiesEvent<Level> event) {
        event.addCapability(new ResourceLocation("xycraft_machines", "collector_volume_cache"), (ICapabilityProvider)new CollectorVolumeCache());
    }

    public CollectorVolumeAnchor createNewAnchor(BlockPos pos) {
        return new CollectorVolumeAnchor(pos);
    }

    public int getRange() {
        return (Integer)MachinesConfig.CollectorRange.get();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return CAPABILITY.orEmpty(cap, this.optional.cast());
    }

    public record CollectorVolumeAnchor(BlockPos pos) implements AnchoredVolumeCache.IVolumeAnchor<CollectorVolumeAnchor>
    {
        public BlockPos getAnchorPos() {
            return this.pos();
        }

        public Block getAnchorBlock() {
            return MachinesContent.Collector.block();
        }
    }
}

