/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.basic;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.CustomColors;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.IBubbleColumnProvider;
import tv.soaryn.xycraft.core.content.blocks.IWrenchUse;
import tv.soaryn.xycraft.core.content.capabilities.player.ModifierKeyCapability;
import tv.soaryn.xycraft.core.utils.ColorSource;
import tv.soaryn.xycraft.world.content.WorldContent;

public class IgnitionPlateBlock
extends ColoredBlock
implements IBubbleColumnProvider {
    public IgnitionPlateBlock() {
        super((ColorSource)CustomColors.Red, WorldContent.KiviProperties());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)CoreStateProperties.Powered, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CoreStateProperties.StateDirection, (Comparable)Direction.UP));
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        return super.rotate(state, level, pos, direction);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hitResult) {
        InteractionResult wrenchResult;
        if (IWrenchUse.hasWrenchLikeAction((Player)player, (ItemStack)player.m_21120_(interactionHand), (boolean)true) && (wrenchResult = IWrenchUse.rotate((BlockState)state, (Level)level, (BlockPos)pos, (BlockHitResult)hitResult)) != null) {
            return wrenchResult;
        }
        return super.m_6227_(state, level, pos, player, interactionHand, hitResult);
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (state.m_61143_((Property)CoreStateProperties.StateDirection) == Direction.UP && direction == Direction.UP && neighborState.m_60713_(Blocks.f_49990_)) {
            level.m_186460_(pos, (Block)this, 20);
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return (Boolean)state.m_61143_((Property)CoreStateProperties.Powered) != false && direction == state.m_61143_((Property)CoreStateProperties.StateDirection);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CoreStateProperties.StateDirection});
        builder.m_61104_(new Property[]{CoreStateProperties.Powered});
    }

    @NotNull
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction direction = ModifierKeyCapability.of((Player)ctx.m_43723_()) ? ctx.m_43719_().m_122424_() : ctx.m_43719_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)CoreStateProperties.StateDirection, (Comparable)direction)).m_61124_((Property)CoreStateProperties.Powered, (Comparable)Boolean.valueOf(false));
    }

    public boolean isFireSource(BlockState state, LevelReader level, BlockPos pos, Direction direction) {
        return (Boolean)state.m_61143_((Property)CoreStateProperties.Powered) != false && direction == state.m_61143_((Property)CoreStateProperties.StateDirection);
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return direction != ((Direction)state.m_61143_((Property)CoreStateProperties.StateDirection)).m_122424_();
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block neighbor, @NotNull BlockPos neighborPos, boolean p_60514_) {
        Direction dir = (Direction)state.m_61143_((Property)CoreStateProperties.StateDirection);
        boolean powered = (Boolean)state.m_61143_((Property)CoreStateProperties.Powered);
        BlockPos activationPos = pos.m_121945_(dir);
        if (!level.m_5776_() && powered != level.m_276867_(pos)) {
            if (powered) {
                level.m_186460_(pos, (Block)this, 2);
            } else {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)CoreStateProperties.Powered, (Comparable)Boolean.valueOf(true)), 2);
                this.On(level.m_8055_(activationPos), level, activationPos, dir);
            }
        }
        if (!level.m_276867_(pos)) {
            state.m_61124_((Property)CoreStateProperties.Powered, (Comparable)Boolean.valueOf(false));
        }
    }

    public void m_213897_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        super.m_213897_(state, level, pos, rand);
        Direction dir = (Direction)state.m_61143_((Property)CoreStateProperties.StateDirection);
        if (dir == Direction.UP) {
            BubbleColumnBlock.m_152707_((LevelAccessor)level, (BlockPos)pos.m_7494_(), (BlockState)state);
        }
        BlockPos activationPos = pos.m_121945_(dir);
        if (((Boolean)state.m_61143_((Property)CoreStateProperties.Powered)).booleanValue() && !level.m_276867_(pos)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)CoreStateProperties.Powered, (Comparable)Boolean.valueOf(false)), 2);
            if (level.m_8055_(activationPos).m_60713_(Blocks.f_50083_)) {
                level.m_46597_(pos.m_121945_(dir), Blocks.f_50016_.m_49966_());
            }
        }
        if (!level.m_276867_(pos)) {
            state.m_61124_((Property)CoreStateProperties.Powered, (Comparable)Boolean.valueOf(false));
        }
    }

    public void On(BlockState blockstate, @NotNull Level level, BlockPos blockpos, Direction direction) {
        if (!(CampfireBlock.m_51321_((BlockState)blockstate) || CandleBlock.m_152845_((BlockState)blockstate) || CandleCakeBlock.m_152910_((BlockState)blockstate))) {
            if (BaseFireBlock.m_49255_((Level)level, (BlockPos)blockpos, (Direction)direction)) {
                level.m_5594_(null, blockpos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
                BlockState fireState = BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)blockpos);
                level.m_7731_(blockpos, fireState, 11);
            }
        } else {
            level.m_5594_(null, blockpos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
            level.m_7731_(blockpos, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
        }
    }

    public void m_6807_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean piston) {
        level.m_186460_(pos, (Block)this, 20);
    }

    public boolean hasDrag(LevelReader level, BlockPos pos, BlockState state) {
        return state.m_61143_((Property)CoreStateProperties.StateDirection) == Direction.UP;
    }

    public boolean getDrag(LevelReader level, BlockPos pos, BlockState state) {
        return (Boolean)state.m_61143_((Property)CoreStateProperties.Powered);
    }

    public void m_141947_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Entity entity) {
        if (state.m_61143_((Property)CoreStateProperties.StateDirection) == Direction.UP && ((Boolean)state.m_61143_((Property)CoreStateProperties.Powered)).booleanValue() && !entity.m_20161_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity))) {
            entity.m_6469_(level.m_269111_().m_269047_(), 1.0f);
        }
        super.m_141947_(level, pos, state, entity);
    }
}

