/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.compat.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import tv.soaryn.xycraft.core.utils.Utils;

public final class FluidBlockRendering {
    private static final Quaternionf SetupOrthoProjectionQuat = new Quaternionf().rotationZ((float)Math.PI).mul((Quaternionfc)new Quaternionf().rotationX((float)Math.toRadians(30.0))).mul((Quaternionfc)new Quaternionf().rotationY((float)Math.toRadians(45.0)));

    private FluidBlockRendering() {
    }

    public static void render(PoseStack stack, Fluid fluid, int x, int y, int width, int height) {
        FluidState fluidState;
        if (fluid instanceof FlowingFluid) {
            FlowingFluid flowing = (FlowingFluid)fluid;
            fluidState = flowing.m_5613_().m_76145_();
        } else {
            fluidState = fluid.m_76145_();
        }
        FluidState fluidState2 = fluidState;
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        RenderSystem.runAsFancy(() -> {
            RenderType renderType = ItemBlockRenderTypes.m_109287_((FluidState)fluidState2);
            renderType.m_110185_();
            PoseStack worldMatStack = RenderSystem.getModelViewStack();
            worldMatStack.m_85836_();
            worldMatStack.m_252931_(stack.m_85850_().m_252922_());
            worldMatStack.m_252880_((float)x, (float)y, 0.0f);
            FogRenderer.m_109017_();
            worldMatStack.m_252880_((float)width / 2.0f, (float)height / 2.0f, 200.0f);
            worldMatStack.m_85841_((float)width * 0.625f, (float)height * 0.625f, 1.0f);
            FluidBlockRendering.setupOrthographicProjection(worldMatStack);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder builder = tesselator.m_85915_();
            builder.m_166779_(renderType.m_173186_(), renderType.m_110508_());
            blockRenderer.m_234363_(BlockPos.f_121853_, (BlockAndTintGetter)new FakeWorld(fluidState2), (VertexConsumer)builder, fluidState2.m_76188_(), fluidState2);
            tesselator.m_85914_();
            renderType.m_110188_();
            worldMatStack.m_85849_();
        });
        RenderSystem.applyModelViewMatrix();
    }

    private static void setupOrthographicProjection(PoseStack worldMatStack) {
        worldMatStack.m_85841_(1.0f, 1.0f, 1.0f);
        worldMatStack.m_252781_(SetupOrthoProjectionQuat);
        worldMatStack.m_252880_(-0.5f, -0.5f, -0.5f);
        RenderSystem.applyModelViewMatrix();
    }

    private static class FakeWorld
    implements BlockAndTintGetter {
        private final FluidState fluidState;

        public FakeWorld(FluidState fluidState) {
            this.fluidState = fluidState;
        }

        public float m_7717_(@NotNull Direction direction, boolean bl) {
            return 1.0f;
        }

        @NotNull
        public LevelLightEngine m_5518_() {
            throw new UnsupportedOperationException();
        }

        public int m_45517_(@NotNull LightLayer lightLayer, @NotNull BlockPos blockPos) {
            return 15;
        }

        public int m_45524_(@NotNull BlockPos blockPos, int i) {
            return 15;
        }

        public int m_6171_(@NotNull BlockPos blockPos, ColorResolver colorResolver) {
            Biome biome;
            Optional biomeRegistry;
            Level level = Utils.getClientLevel();
            if (level != null && (biomeRegistry = level.m_9598_().m_6632_(Registries.f_256952_)).isPresent() && (biome = (Biome)((Registry)biomeRegistry.get()).m_6246_(Biomes.f_48173_)) != null) {
                return colorResolver.m_130045_(biome, 0.0, 0.0);
            }
            return -1;
        }

        public BlockEntity m_7702_(@NotNull BlockPos blockPos) {
            return null;
        }

        @NotNull
        public BlockState m_8055_(BlockPos blockPos) {
            return blockPos.equals((Object)BlockPos.f_121853_) ? this.fluidState.m_76188_() : Blocks.f_50016_.m_49966_();
        }

        @NotNull
        public FluidState m_6425_(BlockPos blockPos) {
            return blockPos.equals((Object)BlockPos.f_121853_) ? this.fluidState : Fluids.f_76191_.m_76145_();
        }

        public int m_141928_() {
            return 0;
        }

        public int m_141937_() {
            return 0;
        }
    }
}

