/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.serialization;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Function5;
import com.mojang.datafixers.util.Function6;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.NotImplementedException;
import tv.soaryn.xycraft.core.utils.serialization.BinaryReader;
import tv.soaryn.xycraft.core.utils.serialization.BinaryWriter;
import tv.soaryn.xycraft.core.utils.value.Reference;
import tv.soaryn.xycraft.core.utils.value.Value;

public interface BinarySerializer<T>
extends BinaryWriter<T>,
BinaryReader<T> {
    default public <V> BinarySerializer<V> map(Function<V, T> encoder, Function<T, V> decoder) {
        return BinarySerializer.of((val, buf) -> this.serialize(encoder.apply(val), buf), buf -> decoder.apply(this.deserialize(buf)));
    }

    default public BinarySerializer<T> nullable() {
        return BinarySerializer.of((val, buf) -> {
            buf.writeBoolean(val != null);
            if (val != null) {
                this.serialize(val, buf);
            }
        }, buf -> buf.readBoolean() ? this.deserialize(buf) : null);
    }

    public static <T> BinarySerializer<T> placeholder() {
        return BinarySerializer.of((val, buf) -> {
            throw new NotImplementedException();
        }, buf -> {
            throw new NotImplementedException();
        });
    }

    public static <T> BinarySerializer<T> of(final BinaryWriter<T> serializer, final BinaryReader<T> deserializer) {
        return new BinarySerializer<T>(){

            @Override
            public void serialize(T value, FriendlyByteBuf buf) {
                serializer.serialize(value, buf);
            }

            @Override
            public T deserialize(FriendlyByteBuf buf) {
                return deserializer.deserialize(buf);
            }
        };
    }

    public static <T extends Enum<T>> BinarySerializer<T> ofEnum(Class<T> type) {
        return BinarySerializer.of((val, buf) -> buf.m_130068_(val), buf -> buf.m_130066_(type));
    }

    public static <T> BinarySerializer<T[]> ofArray(IntFunction<T[]> factory, BinarySerializer<T> serializer) {
        return BinarySerializer.of((val, buf) -> {
            buf.m_130130_(((Object[])val).length);
            for (Object v : val) {
                serializer.serialize(v, buf);
            }
        }, buf -> {
            Object[] array = (Object[])factory.apply(buf.m_130242_());
            for (int i = 0; i < array.length; ++i) {
                array[i] = serializer.deserialize(buf);
            }
            return array;
        });
    }

    public static <T extends Collection<V>, V> BinarySerializer<T> ofCollection(java.util.function.Supplier<T> factory, BinarySerializer<V> serializer) {
        return BinarySerializer.of((val, buf) -> {
            buf.m_130130_(val.size());
            for (Object v : val) {
                serializer.serialize(v, buf);
            }
        }, buf -> {
            Collection collection = (Collection)factory.get();
            int size = buf.m_130242_();
            for (int i = 0; i < size; ++i) {
                collection.add(serializer.deserialize(buf));
            }
            return collection;
        });
    }

    public static <M extends Map<K, V>, K, V> BinarySerializer<M> ofMap(java.util.function.Supplier<M> factory, BinarySerializer<K> keySerializer, BinarySerializer<V> valueSerializer) {
        return BinarySerializer.of((val, buf) -> {
            buf.m_130130_(val.size());
            val.forEach((k, v) -> {
                keySerializer.serialize(k, buf);
                valueSerializer.serialize(v, buf);
            });
        }, buf -> {
            Map map = (Map)factory.get();
            int size = buf.m_130242_();
            for (int i = 0; i < size; ++i) {
                map.put(keySerializer.deserialize(buf), valueSerializer.deserialize(buf));
            }
            return map;
        });
    }

    public static <T> BinarySerializer<T> ofRegistry(ResourceKey<Registry<T>> registryKey) {
        return BinarySerializer.ofRegistry(() -> registryKey);
    }

    public static <T> BinarySerializer<T> ofRegistry(java.util.function.Supplier<ResourceKey<Registry<T>>> registryKey) {
        Supplier registry = Suppliers.memoize(() -> RegistryManager.ACTIVE.getRegistry((ResourceKey)registryKey.get()));
        return BinarySerializer.of((arg_0, arg_1) -> BinarySerializer.lambda$ofRegistry$17((java.util.function.Supplier)registry, arg_0, arg_1), arg_0 -> BinarySerializer.lambda$ofRegistry$18((java.util.function.Supplier)registry, arg_0));
    }

    public static <T> BinarySerializer<? extends Reference<T>> ofReference(BinarySerializer<T> serializer) {
        return BinarySerializer.of((val, buf) -> serializer.serialize(val.get(), buf), buf -> new Value(serializer.deserialize(buf)));
    }

    public static <T> BinarySerializer<T> ofType(java.util.function.Supplier<T> constructor) {
        return BinarySerializer.of((val, buf) -> {}, buf -> constructor.get());
    }

    public static <T, T1> BinarySerializer<T> ofType(Function<T1, T> constructor, Function<T, T1> getter1, BinarySerializer<T1> serializer1) {
        return BinarySerializer.of((val, buf) -> serializer1.serialize(getter1.apply(val), buf), buf -> constructor.apply(serializer1.deserialize(buf)));
    }

    public static <T, T1, T2> BinarySerializer<T> ofType(BiFunction<T1, T2, T> constructor, Function<T, T1> getter1, BinarySerializer<T1> serializer1, Function<T, T2> getter2, BinarySerializer<T2> serializer2) {
        return BinarySerializer.of((val, buf) -> {
            serializer1.serialize(getter1.apply(val), buf);
            serializer2.serialize(getter2.apply(val), buf);
        }, buf -> constructor.apply(serializer1.deserialize(buf), serializer2.deserialize(buf)));
    }

    public static <T, T1, T2, T3> BinarySerializer<T> ofType(Function3<T1, T2, T3, T> constructor, Function<T, T1> getter1, BinarySerializer<T1> serializer1, Function<T, T2> getter2, BinarySerializer<T2> serializer2, Function<T, T3> getter3, BinarySerializer<T3> serializer3) {
        return BinarySerializer.of((val, buf) -> {
            serializer1.serialize(getter1.apply(val), buf);
            serializer2.serialize(getter2.apply(val), buf);
            serializer3.serialize(getter3.apply(val), buf);
        }, buf -> constructor.apply(serializer1.deserialize(buf), serializer2.deserialize(buf), serializer3.deserialize(buf)));
    }

    public static <T, T1, T2, T3, T4> BinarySerializer<T> ofType(Function4<T1, T2, T3, T4, T> constructor, Function<T, T1> getter1, BinarySerializer<T1> serializer1, Function<T, T2> getter2, BinarySerializer<T2> serializer2, Function<T, T3> getter3, BinarySerializer<T3> serializer3, Function<T, T4> getter4, BinarySerializer<T4> serializer4) {
        return BinarySerializer.of((val, buf) -> {
            serializer1.serialize(getter1.apply(val), buf);
            serializer2.serialize(getter2.apply(val), buf);
            serializer3.serialize(getter3.apply(val), buf);
            serializer4.serialize(getter4.apply(val), buf);
        }, buf -> constructor.apply(serializer1.deserialize(buf), serializer2.deserialize(buf), serializer3.deserialize(buf), serializer4.deserialize(buf)));
    }

    public static <T, T1, T2, T3, T4, T5> BinarySerializer<T> ofType(Function5<T1, T2, T3, T4, T5, T> constructor, Function<T, T1> getter1, BinarySerializer<T1> serializer1, Function<T, T2> getter2, BinarySerializer<T2> serializer2, Function<T, T3> getter3, BinarySerializer<T3> serializer3, Function<T, T4> getter4, BinarySerializer<T4> serializer4, Function<T, T5> getter5, BinarySerializer<T5> serializer5) {
        return BinarySerializer.of((val, buf) -> {
            serializer1.serialize(getter1.apply(val), buf);
            serializer2.serialize(getter2.apply(val), buf);
            serializer3.serialize(getter3.apply(val), buf);
            serializer4.serialize(getter4.apply(val), buf);
            serializer5.serialize(getter5.apply(val), buf);
        }, buf -> constructor.apply(serializer1.deserialize(buf), serializer2.deserialize(buf), serializer3.deserialize(buf), serializer4.deserialize(buf), serializer5.deserialize(buf)));
    }

    public static <T, T1, T2, T3, T4, T5, T6> BinarySerializer<T> ofType(Function6<T1, T2, T3, T4, T5, T6, T> constructor, Function<T, T1> getter1, BinarySerializer<T1> serializer1, Function<T, T2> getter2, BinarySerializer<T2> serializer2, Function<T, T3> getter3, BinarySerializer<T3> serializer3, Function<T, T4> getter4, BinarySerializer<T4> serializer4, Function<T, T5> getter5, BinarySerializer<T5> serializer5, Function<T, T6> getter6, BinarySerializer<T6> serializer6) {
        return BinarySerializer.of((val, buf) -> {
            serializer1.serialize(getter1.apply(val), buf);
            serializer2.serialize(getter2.apply(val), buf);
            serializer3.serialize(getter3.apply(val), buf);
            serializer4.serialize(getter4.apply(val), buf);
            serializer5.serialize(getter5.apply(val), buf);
            serializer6.serialize(getter6.apply(val), buf);
        }, buf -> constructor.apply(serializer1.deserialize(buf), serializer2.deserialize(buf), serializer3.deserialize(buf), serializer4.deserialize(buf), serializer5.deserialize(buf), serializer6.deserialize(buf)));
    }

    private static /* synthetic */ Object lambda$ofRegistry$18(java.util.function.Supplier registry, FriendlyByteBuf buf) {
        return ((ForgeRegistry)registry.get()).getValue(buf.m_130242_());
    }

    private static /* synthetic */ void lambda$ofRegistry$17(java.util.function.Supplier registry, Object val, FriendlyByteBuf buf) {
        buf.m_130130_(((ForgeRegistry)registry.get()).getID(val));
    }
}

