/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils.container;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.utils.container.ItemContainer;

public class ItemContainerToItemHandlerAdapter
implements IItemHandlerModifiable {
    private final ItemContainer inventory;
    private final ItemContainer.ItemHandlerBehavior behavior;

    public ItemContainerToItemHandlerAdapter(ItemContainer inventory, ItemContainer.ItemHandlerBehavior behavior) {
        this.inventory = inventory;
        this.behavior = behavior;
    }

    public int getSlots() {
        return this.inventory.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        Objects.checkIndex(slot, this.getSlots());
        return this.inventory.get(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        Preconditions.checkElementIndex((int)slot, (int)this.getSlots());
        ItemStack currentStack = this.inventory.get(slot);
        if (!currentStack.m_41619_() && !ItemHandlerHelper.canItemStacksStack((ItemStack)currentStack, (ItemStack)stack)) {
            return stack;
        }
        if (currentStack.m_41619_()) {
            if (!this.inventory.isValid(slot, stack)) {
                return stack;
            }
            if (!this.behavior.canInsert(slot, stack)) {
                return stack;
            }
            if (!simulate) {
                this.inventory.set(slot, stack);
            }
            return ItemStack.f_41583_;
        }
        if (!this.behavior.canInsert(slot, stack)) {
            return stack;
        }
        int maxSize = currentStack.m_41741_();
        int currentSize = currentStack.m_41613_();
        int inserted = Math.min(maxSize - currentSize, stack.m_41613_());
        ItemStack newStack = currentStack.m_41777_();
        newStack.m_41769_(inserted);
        if (!this.inventory.isValid(slot, newStack)) {
            return stack;
        }
        if (!simulate) {
            this.inventory.set(slot, newStack);
        }
        ItemStack leftover = stack.m_41777_();
        leftover.m_41774_(inserted);
        return leftover;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        Objects.checkIndex(slot, this.getSlots());
        if (!this.behavior.canExtract(slot)) {
            return ItemStack.f_41583_;
        }
        ItemStack currentStack = this.inventory.get(slot);
        if (currentStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (simulate) {
            return currentStack.m_41777_().m_41620_(amount);
        }
        ItemStack leftover = currentStack.m_41777_();
        ItemStack extracted = leftover.m_41620_(amount);
        this.inventory.set(slot, leftover);
        return extracted;
    }

    public int getSlotLimit(int slot) {
        Objects.checkIndex(slot, this.getSlots());
        return this.inventory.getMaxStackSize(slot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        Objects.checkIndex(slot, this.getSlots());
        return this.inventory.isValid(slot, stack) && this.behavior.canInsert(slot, stack);
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        Objects.checkIndex(slot, this.getSlots());
        this.inventory.set(slot, stack);
    }
}

