/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.utils;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FastVolumeLookup<T> {
    private final Long2ObjectMap<ChunkVolumeData<T>> chunkVolumeData = new Long2ObjectOpenHashMap();
    private final Reference2ObjectMap<T, Pair<ChunkPos, ChunkPos>> values = new Reference2ObjectOpenHashMap();
    private final Set<T> valuesView = Collections.unmodifiableSet(this.values.keySet());

    public static <T> FastVolumeLookup<T> of(Level level, Class<T> type) {
        return ((LevelStore)level.getCapability(LevelStore.CAPABILITY).orElse((Object)LevelStore.EMPTY)).getLookup(type);
    }

    public void add(T value, BlockPos corner1, BlockPos corner2) {
        BlockPos minPos = new BlockPos(Math.min(corner1.m_123341_(), corner2.m_123341_()), Math.min(corner1.m_123342_(), corner2.m_123342_()), Math.min(corner1.m_123343_(), corner2.m_123343_()));
        BlockPos maxPos = new BlockPos(Math.max(corner1.m_123341_(), corner2.m_123341_()), Math.max(corner1.m_123342_(), corner2.m_123342_()), Math.max(corner1.m_123343_(), corner2.m_123343_()));
        ChunkPos minChunkPos = new ChunkPos(minPos);
        ChunkPos maxChunkPos = new ChunkPos(maxPos);
        for (int x = minChunkPos.f_45578_; x <= maxChunkPos.f_45578_; ++x) {
            for (int z = minChunkPos.f_45579_; z <= maxChunkPos.f_45579_; ++z) {
                long longChunkPos = ChunkPos.m_45589_((int)x, (int)z);
                ChunkVolumeData volumeData = (ChunkVolumeData)this.chunkVolumeData.computeIfAbsent(longChunkPos, $ -> new ChunkVolumeData());
                volumeData.add(minPos, maxPos, value);
            }
        }
        this.values.put(value, (Object)Pair.of((Object)minChunkPos, (Object)maxChunkPos));
    }

    public void remove(T value) {
        Pair chunkPositions = (Pair)this.values.remove(value);
        if (chunkPositions == null) {
            return;
        }
        ChunkPos minChunkPos = (ChunkPos)chunkPositions.getLeft();
        ChunkPos maxChunkPos = (ChunkPos)chunkPositions.getRight();
        for (int x = minChunkPos.f_45578_; x <= maxChunkPos.f_45578_; ++x) {
            for (int z = minChunkPos.f_45579_; z <= maxChunkPos.f_45579_; ++z) {
                long longChunkPos = ChunkPos.m_45589_((int)x, (int)z);
                ChunkVolumeData volumeData = (ChunkVolumeData)this.chunkVolumeData.get(longChunkPos);
                if (volumeData == null) continue;
                volumeData.remove(value);
            }
        }
    }

    public Stream<T> find(BlockPos pos) {
        long longChunkPos = ChunkPos.m_151388_((BlockPos)pos);
        ChunkVolumeData volumeData = (ChunkVolumeData)this.chunkVolumeData.get(longChunkPos);
        if (volumeData == null) {
            return Stream.empty();
        }
        return volumeData.find(pos);
    }

    public Set<T> getAll() {
        return this.valuesView;
    }

    public static void init() {
        ResourceLocation resourceLocation = new ResourceLocation("xycraft_core", "fast_volume_lookup");
        MinecraftForge.EVENT_BUS.addGenericListener(Level.class, event -> {
            final LazyOptional lazyOptional = LazyOptional.of(LevelStore::new);
            event.addCapability(resourceLocation, new ICapabilityProvider(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                    return LevelStore.CAPABILITY.orEmpty(cap, lazyOptional);
                }
            });
        });
    }

    private static class LevelStore {
        private static final LevelStore EMPTY = new LevelStore();
        private static final Capability<LevelStore> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<LevelStore>(){});
        private final Map<Class<?>, FastVolumeLookup<?>> lookups = new IdentityHashMap();

        private LevelStore() {
        }

        private <T> FastVolumeLookup<T> getLookup(Class<T> type) {
            return this.lookups.computeIfAbsent(type, $ -> new FastVolumeLookup());
        }
    }

    private static class ChunkVolumeData<T> {
        private final Reference2ObjectMap<T, Pair<BlockPos, BlockPos>> values = new Reference2ObjectOpenHashMap();

        private ChunkVolumeData() {
        }

        private void add(BlockPos min, BlockPos max, T value) {
            this.values.put(value, (Object)Pair.of((Object)min, (Object)max));
        }

        private void remove(T value) {
            this.values.remove(value);
        }

        public Stream<T> find(BlockPos pos) {
            return this.values.entrySet().stream().filter(entry -> {
                BlockPos min = (BlockPos)((Pair)entry.getValue()).getLeft();
                BlockPos max = (BlockPos)((Pair)entry.getValue()).getRight();
                return pos.m_123341_() >= min.m_123341_() && pos.m_123341_() <= max.m_123341_() && pos.m_123342_() >= min.m_123342_() && pos.m_123342_() <= max.m_123342_() && pos.m_123343_() >= min.m_123343_() && pos.m_123343_() <= max.m_123343_();
            }).map(Map.Entry::getKey);
        }
    }
}

