/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector4f;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.capabilities.player.ModifierKeyCapability;
import tv.soaryn.xycraft.core.network.packets.SBGhostSlotClickPacket;
import tv.soaryn.xycraft.core.network.packets.SBGhostSlotScrollPacket;
import tv.soaryn.xycraft.core.ui.BaseMenu;
import tv.soaryn.xycraft.core.ui.NineSlicedResource;
import tv.soaryn.xycraft.core.ui.Rectangle;
import tv.soaryn.xycraft.core.ui.TiledIcon;
import tv.soaryn.xycraft.core.ui.widget.IWidget;
import tv.soaryn.xycraft.core.ui.widget.WidgetState;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.core.utils.container.ColoredSlot;
import tv.soaryn.xycraft.core.utils.container.GhostSlot;

public class BaseMenuUI<T extends BaseMenu>
extends AbstractContainerScreen<T> {
    private final List<IWidget> _widgets = new ArrayList<IWidget>();
    private final ResourceLocation _lockResource = new ResourceLocation("xycraft_core", "textures/gui/lock.png");

    public BaseMenuUI(T menu, Inventory playerInv, Component title, int width, int height) {
        super(menu, playerInv, title);
        this.f_97726_ = width;
        this.f_97727_ = height;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
        this._widgets.clear();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
    }

    protected final void add(IWidget widget) {
        this._widgets.add(widget);
    }

    protected void m_181908_() {
        super.m_181908_();
    }

    public void m_7379_() {
        super.m_7379_();
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        this.renderWidgets(graphics, mouseX, mouseY, partialTick, this._widgets.stream().filter(IWidget.Background.class::isInstance).toList());
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        NineSlicedResource slotUi = new NineSlicedResource(new ResourceLocation("xycraft_core", "textures/gui/sliced/slot2.png"));
        NineSlicedResource slotHighlight = new NineSlicedResource(new ResourceLocation("xycraft_core", "textures/gui/sliced/slot_highlight.png"));
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        RenderSystem.setShaderColor((float)0.6f, (float)0.6f, (float)0.6f, (float)0.9f);
        int left = (this.f_96543_ - this.f_97726_) / 2;
        int top = (this.f_96544_ - this.f_97727_) / 2;
        for (Slot slot : ((BaseMenu)this.f_97732_).f_38839_) {
            slotUi.render(poseStack, left + slot.f_40220_ - 1, top + slot.f_40221_ - 1, 18.0f, 18.0f, 1.0f);
        }
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        for (Slot slot : ((BaseMenu)this.f_97732_).f_38839_) {
            ColoredSlot s;
            int color;
            if (!(slot instanceof ColoredSlot) || (color = (s = (ColoredSlot)slot).getColor()) == 0) continue;
            graphics.m_280509_(this.f_97735_ + slot.f_40220_, this.f_97736_ + slot.f_40221_, this.f_97735_ + slot.f_40220_ + 16, this.f_97736_ + slot.f_40221_ + 16, color);
        }
        Vector4f rgba = ColorUtils.convertRGBAToComponents(-867893334);
        poseStack.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)rgba.x(), (float)rgba.y(), (float)rgba.z(), (float)rgba.w());
        for (Slot slot : ((BaseMenu)this.f_97732_).f_38839_) {
            GhostSlot s;
            if (!(slot instanceof GhostSlot) || !(s = (GhostSlot)slot).isStrict()) continue;
            slotHighlight.render(poseStack, left + slot.f_40220_ - 1, top + slot.f_40221_ - 1, 18.0f, 18.0f, 1.0f);
        }
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.renderWidgets(graphics, mouseX, mouseY, partialTick, this._widgets.stream().filter(IWidget.Foreground.class::isInstance).toList());
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        Vector4f rgba = ColorUtils.convertRGBAToComponents(-867893334);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)rgba.x(), (float)rgba.y(), (float)rgba.z(), (float)rgba.w());
        RenderSystem._setShaderTexture((int)0, (ResourceLocation)this._lockResource);
        PoseStack poseStack = graphics.m_280168_();
        for (Slot slot : ((BaseMenu)this.f_97732_).f_38839_) {
            GhostSlot s;
            if (!(slot instanceof GhostSlot) || !(s = (GhostSlot)slot).isStrict()) continue;
            TiledIcon.innerBlit(poseStack, (float)(this.f_97735_ + slot.f_40220_ + 10), (float)(this.f_97735_ + slot.f_40220_ + 16), (float)(this.f_97736_ + slot.f_40221_), (float)(this.f_97736_ + slot.f_40221_ + 6), 301.0f, 0.0f, 1.0f, 0.0f, 1.0f);
        }
        this.m_280072_(graphics, mouseX, mouseY);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderWidgets(GuiGraphics graphics, int mouseX, int mouseY, float partialTick, List<IWidget> widgets) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack poseStack = graphics.m_280168_();
        for (IWidget widget : widgets) {
            IWidget.Data data = widget.getData();
            if (data.State == WidgetState.Hidden) continue;
            poseStack.m_85836_();
            float radians = (float)Math.toRadians(data.Rotation);
            poseStack.m_252880_((float)this.f_97735_, (float)this.f_97736_, 0.0f);
            poseStack.m_85836_();
            poseStack.m_252880_(data.Dimensions.x(), data.Dimensions.y(), 0.0f);
            float centerX = data.Dimensions.width() / 2.0f;
            float centerY = data.Dimensions.height() / 2.0f;
            poseStack.m_252880_(centerX, centerY, 0.0f);
            poseStack.m_252781_(new Quaternionf().rotationZ(radians));
            poseStack.m_252880_(-centerX, -centerY, 0.0f);
            widget.render(graphics, (int)((float)mouseX - data.Dimensions.x()), (int)((float)mouseY - data.Dimensions.y()), partialTick);
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void m_280072_(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        GhostSlot ghostSlot;
        Object itemstack;
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        ArrayList<Component> toolTipList = new ArrayList<Component>();
        Optional optional = Optional.empty();
        if (this.f_97734_ != null && !(itemstack = this.f_97734_.m_7993_()).m_41619_()) {
            optional = itemstack.m_150921_();
            toolTipList.addAll(this.m_280553_((ItemStack)itemstack));
        }
        for (IWidget widget : this._widgets) {
            IWidget.Data data = widget.getData();
            if (data.State == WidgetState.Hidden || !this.isInWidget(widget, mouseX, mouseY)) continue;
            widget.onToolTip((float)mouseX - ((float)this.f_97735_ + data.Dimensions.x()), (float)mouseY - ((float)this.f_97736_ + data.Dimensions.y()), toolTipList);
            if (toolTipList.isEmpty()) continue;
        }
        Slot slot = this.f_97734_;
        if (slot instanceof GhostSlot && (ghostSlot = (GhostSlot)slot).isStrict()) {
            toolTipList.add((Component)Component.m_237115_((String)"gui.xycraft_core.slot.strict").m_130938_(style -> style.m_178520_(-867893334)));
        }
        graphics.m_280677_(this.f_96547_, toolTipList, optional, mouseX, mouseY);
    }

    public boolean m_6375_(double x, double y, int button) {
        GhostSlot ghostSlot;
        Slot slot;
        if (this.f_97734_ != null && (slot = this.f_97734_) instanceof GhostSlot && !(ghostSlot = (GhostSlot)slot).isLocked()) {
            ItemStack carried = ((BaseMenu)this.f_97732_).m_142621_();
            ItemStack placed = carried.m_41777_().m_41620_(this.f_97734_.m_5866_(carried));
            if (button == 2) {
                return super.m_6375_(x, y, button);
            }
            if (placed.m_41619_()) {
                if (ModifierKeyCapability.of(Utils.getClientPlayer())) {
                    if (!this.f_97734_.m_6657_()) {
                        return false;
                    }
                    XyCore.Network.send(new SBGhostSlotClickPacket(this.f_97734_.f_40219_, false, !ghostSlot.isStrict()));
                    this.f_97734_.m_6654_();
                } else {
                    this.f_97734_.m_5852_(placed);
                    XyCore.Network.send(new SBGhostSlotClickPacket(this.f_97734_.f_40219_, true, false));
                }
            } else {
                boolean restrict = ModifierKeyCapability.of(Utils.getClientPlayer());
                this.f_97734_.m_5852_(placed);
                XyCore.Network.send(new SBGhostSlotClickPacket(this.f_97734_.f_40219_, true, restrict));
            }
            return true;
        }
        for (IWidget widget : this._widgets) {
            Rectangle dimensions;
            if (!this.isInWidget(widget, x, y) || !widget.onMouseDown(x - (double)(dimensions = widget.getData().Dimensions.offset(this.f_97735_, this.f_97736_)).x(), y - (double)dimensions.y(), button)) continue;
            return true;
        }
        return super.m_6375_(x, y, button);
    }

    private boolean isInWidget(IWidget widget, double x, double y) {
        if (widget.getData().State == WidgetState.Hidden) {
            return false;
        }
        Rectangle dimensions = widget.getData().Dimensions.toScreen(this.f_97735_, this.f_97736_);
        return dimensions.contains(x, y);
    }

    protected boolean m_6774_(int slotX, int slotY, int width, int height, double x, double y) {
        for (IWidget widget : this._widgets) {
            if (widget.getData().State == WidgetState.Hidden) continue;
            widget.setHovering(this.isInWidget(widget, x, y));
        }
        return super.m_6774_(slotX, slotY, width, height, x, y);
    }

    public boolean m_6348_(double x, double y, int button) {
        return super.m_6348_(x, y, button);
    }

    public boolean m_6050_(double x, double y, double amount) {
        GhostSlot slot;
        Slot slot2;
        if (this.f_97734_ != null && (slot2 = this.f_97734_) instanceof GhostSlot && !(slot = (GhostSlot)slot2).isLocked()) {
            ItemStack stack = slot.m_7993_();
            if (!stack.m_41619_()) {
                int delta = Mth.m_14205_((double)amount) * (BaseMenuUI.m_96638_() ? 8 : 1);
                stack.m_41764_(Math.max(1, Math.min(stack.m_41613_() + delta, slot.m_6641_())));
                XyCore.Network.send(new SBGhostSlotScrollPacket(this.f_97734_.f_40219_, delta));
            }
            return true;
        }
        return super.m_6050_(x, y, amount);
    }
}

