/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.imc;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.blocks.BubbleColumnProviders;

public class IMCRegistries {
    public static HashMap<BlockState, BlockState> SolidBlockToFromMap = new HashMap();

    public static class Receive {
        public static void onInterModProcess(InterModProcessEvent event) {
            Receive.handleBubbleColumnIMC(event);
            Receive.handleSolidifierIMC(event);
        }

        private static void handleBubbleColumnIMC(InterModProcessEvent event) {
            event.getIMCStream("register_bubble_column_provider"::equals).forEach(imcMessage -> {
                try {
                    Triplet tuple;
                    Object patt3577$temp;
                    Object patt3526$temp = imcMessage.messageSupplier().get();
                    if (patt3526$temp instanceof Triplet && (patt3577$temp = (tuple = (Triplet)patt3526$temp).getA()) instanceof Block) {
                        Block block = (Block)patt3577$temp;
                        Object patt3616$temp = tuple.getB();
                        if (patt3616$temp instanceof PropertyDispatch.TriFunction) {
                            PropertyDispatch.TriFunction fun1 = (PropertyDispatch.TriFunction)patt3616$temp;
                            Object patt3689$temp = tuple.getC();
                            if (patt3689$temp instanceof PropertyDispatch.TriFunction) {
                                PropertyDispatch.TriFunction fun2 = (PropertyDispatch.TriFunction)patt3689$temp;
                                BubbleColumnProviders.register(block, (PropertyDispatch.TriFunction<LevelReader, BlockPos, BlockState, Boolean>)fun1, (PropertyDispatch.TriFunction<LevelReader, BlockPos, BlockState, Boolean>)fun2);
                                XyCore.Logger.debug("Registered %s as a BubbleColumnProvider".formatted(block.m_49954_().getString()));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    XyCore.Logger.error("%s tried to send an invalid message for registering a BubbleColumnProvider: [%s]".formatted(imcMessage.senderModId(), e.getMessage()));
                }
            });
        }

        private static void handleSolidifierIMC(InterModProcessEvent event) {
            event.getIMCStream("register_solidifier"::equals).forEach(imcMessage -> {
                try {
                    Pair pair;
                    Object patt4722$temp;
                    Object patt4679$temp = imcMessage.messageSupplier().get();
                    if (patt4679$temp instanceof Pair && (patt4722$temp = (pair = (Pair)patt4679$temp).getA()) instanceof BlockState) {
                        BlockState from = (BlockState)patt4722$temp;
                        Object patt4764$temp = pair.getB();
                        if (patt4764$temp instanceof BlockState) {
                            BlockState to = (BlockState)patt4764$temp;
                            SolidBlockToFromMap.put(from, to);
                            XyCore.Logger.debug("Registered %s as a Solidifier to %s".formatted(from.m_60734_().m_49954_().getString(), to.m_60734_().m_49954_().getString()));
                        }
                    }
                }
                catch (Exception e) {
                    XyCore.Logger.error("%s tried to send an invalid message for registering a Solidifier: [%s]".formatted(imcMessage.senderModId(), e.getMessage()));
                }
            });
        }
    }

    public static class Send {
        public static void registerBubbleColumn(Block block, PropertyDispatch.TriFunction<LevelReader, BlockPos, BlockState, Boolean> hasDrag, PropertyDispatch.TriFunction<LevelReader, BlockPos, BlockState, Boolean> getDrag) {
            InterModComms.sendTo((String)"xycraft_core", (String)"register_bubble_column_provider", () -> new Triplet((Object)block, (Object)hasDrag, (Object)getDrag));
        }

        public static void registerSolidifier(Block from, Block to) {
            Send.registerSolidifier(from.m_49966_(), to.m_49966_());
        }

        public static void registerSolidifier(BlockState from, BlockState to) {
            InterModComms.sendTo((String)"xycraft_core", (String)"register_solidifier", () -> new Pair((Object)from, (Object)to));
        }

        public static void registerNoDarkmode(String namespaceKey) {
            InterModComms.sendTo((String)"darkmodeeverywhere", (String)"dme-shaderblacklist", () -> namespaceKey);
        }
    }
}

