/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.experimental;

import com.google.common.base.CaseFormat;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.ItemContent;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.items.XyBlockItem;

public class ContentBuilder {
    private static final ArrayList<ContentBuilder> Builders = new ArrayList();
    protected static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    protected int _fieldIndex;
    protected final String[] _fieldNames;
    private final DeferredRegister<Block> _blockMap;
    private final DeferredRegister<Item> _itemMap;
    private final CreativeModeTab _tab;
    public final ArrayList<BlockContent> ListOfBlocks = new ArrayList();
    public final ArrayList<ItemContent> ListOfItems = new ArrayList();
    private String _name;
    private BlockBehaviour.Properties _blockProperties;

    public ContentBuilder(String modId, CreativeModeTab tab) {
        this._blockMap = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)modId);
        this._itemMap = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)modId);
        this._tab = tab;
        Builders.add(this);
        Class<?> c = STACK_WALKER.getCallerClass();
        Class t = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this._fieldNames = (String[])Arrays.stream(c.getFields()).filter(field -> field.getType().isAssignableFrom(t) || field.getType().isAssignableFrom(EnumMap.class) && ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[1].getTypeName().equals(BlockContent.class.getTypeName())).map(field -> CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, field.getName())).toArray(String[]::new);
    }

    public ContentBuilder withProperties(BlockBehaviour.Properties properties) {
        this._blockProperties = properties;
        return this;
    }

    private void reset() {
        this._name = null;
        this._blockProperties = BlockBehaviour.Properties.m_284310_();
    }

    public BlockContent block() {
        String id = this._fieldNames[this._fieldIndex++];
        RegistryObject blockR = this._blockMap.register(id, XyBlock::new);
        RegistryObject itemR = this._itemMap.register(id, () -> new XyBlockItem((Block)blockR.get(), new Item.Properties()));
        BlockContent content = new BlockContent((RegistryObject<Block>)blockR, (RegistryObject<Item>)itemR);
        this.ListOfBlocks.add(content);
        return content;
    }

    public BlockContent block(Function<BlockBehaviour.Properties, Supplier<Block>> blockSupplier) {
        String id = this._fieldNames[this._fieldIndex++];
        RegistryObject blockR = this._blockMap.register(id, blockSupplier.apply(this._blockProperties));
        RegistryObject itemR = this._itemMap.register(id, () -> new XyBlockItem((Block)blockR.get(), new Item.Properties()));
        BlockContent content = new BlockContent((RegistryObject<Block>)blockR, (RegistryObject<Item>)itemR);
        this.ListOfBlocks.add(content);
        return content;
    }
}

