/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.capabilities.volumes;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.utils.FastVolumeLookup;

public abstract class AnchoredVolumeCache<T extends IVolumeAnchor<T>>
implements ICapabilitySerializable<CompoundTag> {
    public final Class<T> AnchorClass;
    protected final LazyOptional<AnchoredVolumeCache<T>> optional = LazyOptional.of(() -> this);
    private final Long2ObjectMap<T> anchorVolumes = new Long2ObjectOpenHashMap();

    protected AnchoredVolumeCache(Class<T> anchorClass) {
        this.AnchorClass = anchorClass;
    }

    public abstract T createNewAnchor(BlockPos var1);

    public abstract int getRange();

    public Iterable<T> list() {
        return this.anchorVolumes.values();
    }

    @Nullable
    public T get(BlockPos pos) {
        return (T)((IVolumeAnchor)this.anchorVolumes.get(pos.m_121878_()));
    }

    public void load(Level level) {
        FastVolumeLookup volumes = FastVolumeLookup.of(level, this.AnchorClass);
        int offset = this.getRange();
        this.anchorVolumes.long2ObjectEntrySet().forEach(lightFieldVolumeEntry -> {
            IVolumeAnchor field = (IVolumeAnchor)lightFieldVolumeEntry.getValue();
            BlockPos pos = field.getAnchorPos();
            volumes.add(field, pos.m_7918_(-offset, -offset, -offset), pos.m_7918_(offset, offset, offset));
        });
        this.revalidate(level);
    }

    public void add(Level level, BlockPos anchorPos) {
        T anchor = this.createNewAnchor(anchorPos);
        this.anchorVolumes.put(anchorPos.m_121878_(), anchor);
        int offsets = this.getRange();
        FastVolumeLookup.of(level, this.AnchorClass).add(anchor, anchorPos.m_7918_(-offsets, -offsets, -offsets), anchorPos.m_7918_(offsets, offsets, offsets));
    }

    public void remove(Level level, BlockPos pos) {
        IVolumeAnchor field = (IVolumeAnchor)this.anchorVolumes.remove(pos.m_121878_());
        if (field != null) {
            FastVolumeLookup.of(level, this.AnchorClass).remove(field);
        }
    }

    public void clear(Level level) {
        this.anchorVolumes.forEach((aLong, t) -> FastVolumeLookup.of(level, this.AnchorClass).remove((IVolumeAnchor)t));
        this.anchorVolumes.clear();
    }

    public int revalidate(Level level) {
        ArrayList<IVolumeAnchor> list = new ArrayList<IVolumeAnchor>();
        this.anchorVolumes.forEach((posLong, volume) -> {
            BlockState blockState = level.m_8055_(volume.getAnchorPos());
            if (!blockState.m_60713_(volume.getAnchorBlock())) {
                XyCore.Logger.warn("Volume Cache has an orphaned volume at %s".formatted(volume.getAnchorPos()));
                list.add((IVolumeAnchor)volume);
            }
        });
        list.forEach(volume -> this.remove(level, volume.getAnchorPos()));
        int count = list.size();
        list.clear();
        return count;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128388_("positions", this.anchorVolumes.keySet().toLongArray());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        long[] positions;
        for (long position : positions = nbt.m_128467_("positions")) {
            this.anchorVolumes.put(position, this.createNewAnchor(BlockPos.m_122022_((long)position)));
        }
    }

    public static interface IVolumeAnchor<T> {
        public BlockPos getAnchorPos();

        public Block getAnchorBlock();
    }
}

