/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.capabilities.player;

import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.CoreCapabilities;
import tv.soaryn.xycraft.core.network.packets.SBModifierKeyPacket;
import tv.soaryn.xycraft.core.utils.Input;
import tv.soaryn.xycraft.core.utils.Utils;

@AutoRegisterCapability
public interface ModifierKeyCapability
extends ICapabilityProvider {
    public static boolean of(Player player) {
        if (player == null) {
            return false;
        }
        return player.getCapability(CoreCapabilities.Player.ModifierKey).map(ModifierKeyCapability::isDown).orElse(false);
    }

    public boolean isDown();

    public void setDown(boolean var1);

    @Mod.EventBusSubscriber(modid="xycraft_core", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class Handle
    implements ModifierKeyCapability {
        private final LazyOptional<ModifierKeyCapability> optional = LazyOptional.of(() -> this);
        private boolean _isDown;

        @Override
        public boolean isDown() {
            return this._isDown;
        }

        @Override
        public void setDown(boolean flag) {
            this._isDown = flag;
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onInputKey(InputEvent.Key event) {
            int action = event.getAction();
            if (action == 2) {
                return;
            }
            Player player = Utils.getClientPlayer();
            if (player == null || !Input.ModifierKey.m_90832_(event.getKey(), event.getScanCode())) {
                return;
            }
            LazyOptional provider = player.getCapability(CoreCapabilities.Player.ModifierKey);
            provider.ifPresent(modifierKeyCapability -> modifierKeyCapability.setDown(action == 1));
            XyCore.Network.send(new SBModifierKeyPacket(action == 1));
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return CoreCapabilities.Player.ModifierKey.orEmpty(cap, this.optional.cast());
        }
    }
}

