/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.CoreTags;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.capabilities.player.ModifierKeyCapability;

public interface IWrenchUse {
    public static boolean hasWrenchLikeAction(@NotNull Player player, ItemStack stack, boolean canBeEmptyHand) {
        return stack.m_204117_(CoreTags.Items.ForgeWrench) || ModifierKeyCapability.of(player) && stack.m_41619_() && canBeEmptyHand;
    }

    public static InteractionResult rotate(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockHitResult hit) {
        Direction currentDirection = (Direction)state.m_61143_(CoreStateProperties.StateDirection);
        Direction targeted = hit.m_82434_();
        if (targeted != currentDirection && targeted != currentDirection.m_122424_()) {
            Direction dir = targeted.m_122421_() == Direction.AxisDirection.NEGATIVE ? currentDirection.m_175364_(targeted.m_122434_()) : currentDirection.m_175362_(targeted.m_122434_());
            BlockState newState = (BlockState)state.m_61124_(CoreStateProperties.StateDirection, (Comparable)dir);
            level.m_7731_(pos, newState, 11);
            level.markAndNotifyBlock(pos, level.m_46745_(pos), newState, state, 3, 512);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return null;
    }

    @Nullable
    public InteractionResult onWrenchUsed(@NotNull BlockState var1, @NotNull Level var2, @NotNull BlockPos var3, @NotNull Player var4, @NotNull InteractionHand var5, @NotNull BlockHitResult var6);
}

