/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.effects;

import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.client.render.util.HiddenDurationEffectRenderer;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.effects.WerewolvesEffect;
import de.teamlapen.werewolves.effects.inst.LupusSanguinemEffectInstance;
import de.teamlapen.werewolves.util.Helper;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;

public class LupusSanguinemEffect
extends WerewolvesEffect {
    public LupusSanguinemEffect() {
        super(MobEffectCategory.HARMFUL, 14684911);
    }

    public static void infectRandomByPlayer(@Nonnull LivingEntity entity) {
        LupusSanguinemEffect.addSanguinemEffectRandom(entity, (Double)WerewolvesConfig.SERVER.playerBiteInfectChance.get());
    }

    public static void infectRandomByMob(@Nonnull LivingEntity entity) {
        LupusSanguinemEffect.addSanguinemEffectRandom(entity, (Double)WerewolvesConfig.SERVER.mobBiteInfectChance.get());
    }

    public static void addSanguinemEffectRandom(@Nonnull LivingEntity entity, double chance) {
        if ((double)entity.m_217043_().m_188501_() < chance) {
            LupusSanguinemEffect.addSanguinemEffect(entity);
        }
    }

    public static void addSanguinemEffect(@Nonnull LivingEntity entity) {
        boolean canBecomeWerewolf = false;
        if (entity instanceof Player) {
            canBecomeWerewolf = Helper.canBecomeWerewolf((Player)entity);
        }
        if (canBecomeWerewolf) {
            entity.m_7292_((MobEffectInstance)new LupusSanguinemEffectInstance(Integer.MAX_VALUE));
        }
    }

    public void m_6742_(@Nonnull LivingEntity entityLivingBaseIn, int amplifier) {
        if (entityLivingBaseIn instanceof Player) {
            FactionPlayerHandler.getOpt((Player)((Player)entityLivingBaseIn)).ifPresent(player -> player.joinFaction(WReference.WEREWOLF_FACTION));
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration == 2;
    }

    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        consumer.accept(new HiddenDurationEffectRenderer());
    }
}

