/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.blocks.entity;

import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.werewolves.blocks.WolfsbaneDiffuserBlock;
import de.teamlapen.werewolves.core.ModTiles;
import de.teamlapen.werewolves.world.WerewolvesWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WolfsbaneDiffuserBlockEntity
extends BlockEntity {
    private static final int FUEL_DURATION = 2400;
    private WolfsbaneDiffuserBlock.Type type = WolfsbaneDiffuserBlock.Type.NORMAL;
    private int id;
    private boolean registered = false;
    private int fueled = 0;
    private int bootTimer = -1;
    private int maxBootTimer;
    private boolean initiateBootTimer = false;

    public WolfsbaneDiffuserBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModTiles.WOLFSBANE_DIFFUSER.get(), pPos, pBlockState);
    }

    public float getBootProgress() {
        return this.bootTimer > 0 ? 1.0f - (float)this.bootTimer / (float)this.maxBootTimer : 1.0f;
    }

    public int getFuelTime() {
        return this.fueled;
    }

    public float getFueledState() {
        return (float)this.fueled / (float)this.type.fuelTime.get().intValue();
    }

    public void m_6339_() {
        super.m_6339_();
        if (this.isActive()) {
            this.register();
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public boolean isActive() {
        return this.bootTimer == 0;
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public boolean isInRange(@NotNull BlockPos pos) {
        return new ChunkPos(this.m_58899_()).m_45594_(new ChunkPos(pos)) <= this.radius();
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.type = WolfsbaneDiffuserBlock.Type.valueOf(compound.m_128461_("type"));
        this.bootTimer = compound.m_128451_("boot_timer");
        this.maxBootTimer = compound.m_128441_("max_boot_timer") ? compound.m_128451_("max_boot_timer") : 1;
        this.setFueledTime(compound.m_128451_("fueled"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDataPacket(Connection net, @NotNull ClientboundBlockEntityDataPacket pkt) {
        if (this.m_58898_()) {
            CompoundTag nbt = pkt.m_131708_();
            this.handleUpdateTag(nbt);
            if (this.isActive()) {
                this.register();
            }
        }
    }

    public void onTouched(@NotNull Player player) {
    }

    private int radius() {
        return this.type.range.get();
    }

    public void onFueled() {
        this.setFueledTime(this.type.fuelTime.get());
        this.updateLevel();
    }

    public void setNewBootDelay(int delayTicks) {
        this.bootTimer = delayTicks;
        this.maxBootTimer = delayTicks;
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128359_("type", this.type.name());
        compound.m_128405_("fueled", this.fueled);
        if (this.bootTimer != 0) {
            compound.m_128405_("boot_timer", this.bootTimer);
            compound.m_128405_("max_boot_timer", this.maxBootTimer);
        }
    }

    public void initiateBootTimer() {
        this.initiateBootTimer = true;
    }

    public void setType(WolfsbaneDiffuserBlock.Type type) {
        this.type = type;
    }

    public void updateLevel() {
        this.m_6596_();
        if (this.m_58898_()) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.unregister();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, @NotNull WolfsbaneDiffuserBlockEntity blockEntity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (blockEntity.initiateBootTimer) {
                blockEntity.initiateBootTimer = false;
                int bootTime = (Integer)VampirismConfig.BALANCE.garlicDiffuserStartupTime.get() * 20;
                if (serverLevel.m_6907_().size() <= 1) {
                    bootTime >>= 2;
                }
                if (blockEntity.type == WolfsbaneDiffuserBlock.Type.LONG) {
                    bootTime *= 2;
                }
                blockEntity.bootTimer = bootTime;
                blockEntity.maxBootTimer = bootTime;
                blockEntity.updateLevel();
            }
        }
        if (blockEntity.bootTimer > 0) {
            if (--blockEntity.bootTimer == 0) {
                blockEntity.updateLevel();
                blockEntity.register();
            }
        } else if (blockEntity.fueled > 0) {
            if (blockEntity.fueled == 1) {
                blockEntity.setFueledTime(0);
                blockEntity.updateLevel();
            } else {
                --blockEntity.fueled;
                blockEntity.m_6596_();
            }
        }
    }

    private void register() {
        if (this.registered || !this.m_58898_()) {
            return;
        }
        int baseX = this.m_58899_().m_123341_() >> 4;
        int baseZ = this.m_58899_().m_123343_() >> 4;
        int radius = this.radius();
        ChunkPos[] chunks = new ChunkPos[(2 * radius + 1) * (2 * radius + 1)];
        int i = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                chunks[i++] = new ChunkPos(x + baseX, z + baseZ);
            }
        }
        this.id = WerewolvesWorld.getOpt(this.m_58904_()).map(vw -> vw.registerWolfsbaneDiffuserBlock(this.fueled > 0 ? this.type.amplifier : 0, chunks)).orElse(0);
        this.registered = i != 0;
    }

    private void setFueledTime(int time) {
        int old = this.fueled;
        this.fueled = time;
        if ((time > 0 && old == 0 || time == 0 && old > 0) && !this.m_58901_()) {
            this.unregister();
            this.register();
        }
    }

    private void unregister() {
        if (this.registered && this.m_58898_()) {
            WerewolvesWorld.getOpt(this.m_58904_()).ifPresent(vw -> vw.removeWolfsbaneBlocksBlock(this.id));
            this.registered = false;
        }
    }
}

