/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.ISundamageRegistry;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.network.ClientboundSundamagePacket;
import de.teamlapen.vampirism.util.Helper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class SundamageRegistry
implements ISundamageRegistry {
    @Nullable
    private RegistryAccess registryAccess;
    private Settings dataSettings = Settings.EMPTY;
    private final APISettings apiSettings = new APISettings(new ArrayList<ResourceKey<Biome>>(), new ArrayList<ResourceKey<DimensionType>>(), new ArrayList<ResourceKey<Level>>(), new ArrayList<ResourceKey<Level>>());
    private ConfigSettings configSettings = new ConfigSettings(new HashSet<ResourceKey<Level>>(), new HashSet<ResourceKey<Level>>(), new HashSet<ResourceKey<Biome>>());
    private Set<ResourceKey<DimensionType>> noSunDamageDimensions = new HashSet<ResourceKey<DimensionType>>();
    private Set<ResourceKey<Biome>> noSunDamageBiomes = new HashSet<ResourceKey<Biome>>();
    private Set<ResourceKey<Level>> noSunDamageLevels = new HashSet<ResourceKey<Level>>();
    private Set<ResourceKey<Level>> sunDamageLevels = new HashSet<ResourceKey<Level>>();

    public void reloadSettings() {
        if (this.registryAccess != null) {
            Set biomes = this.dataSettings.biomesWithout.m_203614_().map(Holder::m_203543_).flatMap(Optional::stream).collect(Collectors.toSet());
            Set dimensions = this.dataSettings.dimensionWithout.m_203614_().map(Holder::m_203543_).flatMap(Optional::stream).collect(Collectors.toSet());
            HashSet<ResourceKey<Level>> noSundamageLevels = new HashSet<ResourceKey<Level>>(this.dataSettings.levelsWithoutSunDamage());
            HashSet<ResourceKey<Level>> sundamageLevels = new HashSet<ResourceKey<Level>>(this.dataSettings.levelsWithSunDamage());
            biomes.addAll(this.apiSettings.biomes);
            dimensions.addAll(this.apiSettings.dimensions);
            this.apiSettings.levels.forEach(level -> {
                noSundamageLevels.add((ResourceKey<Level>)level);
                sundamageLevels.remove(level);
            });
            this.apiSettings.sundamageLevels.forEach(level -> {
                noSundamageLevels.remove(level);
                sundamageLevels.add((ResourceKey<Level>)level);
            });
            biomes.addAll(this.configSettings.biomes);
            this.configSettings.levels.forEach(level -> {
                noSundamageLevels.add((ResourceKey<Level>)level);
                sundamageLevels.remove(level);
            });
            this.configSettings.sundamageLevels.forEach(level -> {
                noSundamageLevels.remove(level);
                sundamageLevels.add((ResourceKey<Level>)level);
            });
            this.noSunDamageBiomes = Collections.unmodifiableSet(biomes);
            this.noSunDamageDimensions = Collections.unmodifiableSet(dimensions);
            this.noSunDamageLevels = Collections.unmodifiableSet(noSundamageLevels);
            this.sunDamageLevels = Collections.unmodifiableSet(sundamageLevels);
            this.updateClients();
        } else {
            this.noSunDamageBiomes = Collections.emptySet();
            this.noSunDamageDimensions = Collections.emptySet();
            this.noSunDamageLevels = Collections.emptySet();
            this.sunDamageLevels = Collections.emptySet();
        }
    }

    public void updateClients() {
        VampirismMod.dispatcher.sendToAll(new ClientboundSundamagePacket(new ArrayList<ResourceKey<DimensionType>>(this.noSunDamageDimensions), new ArrayList<ResourceKey<Biome>>(this.noSunDamageBiomes), new ArrayList<ResourceKey<Level>>(this.noSunDamageLevels), new ArrayList<ResourceKey<Level>>(this.sunDamageLevels)));
    }

    public void updateClient(@NotNull ServerPlayer player) {
        VampirismMod.dispatcher.sendTo(new ClientboundSundamagePacket(new ArrayList<ResourceKey<DimensionType>>(this.noSunDamageDimensions), new ArrayList<ResourceKey<Biome>>(this.noSunDamageBiomes), new ArrayList<ResourceKey<Level>>(this.noSunDamageLevels), new ArrayList<ResourceKey<Level>>(this.sunDamageLevels)), player);
    }

    public void applyData(Settings settings) {
        this.dataSettings = settings;
    }

    public void reloadConfiguration() {
        Set<ResourceKey<Biome>> biomes = ((List)VampirismConfig.SERVER.sundamageDisabledBiomes.get()).stream().map(ResourceLocation::new).map(s -> ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)s)).collect(Collectors.toUnmodifiableSet());
        Set<ResourceKey<Level>> levels = ((List)VampirismConfig.SERVER.sundamageDimensionsOverrideNegative.get()).stream().map(ResourceLocation::new).map(s -> ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)s)).collect(Collectors.toUnmodifiableSet());
        Set<ResourceKey<Level>> positiveLevels = ((List)VampirismConfig.SERVER.sundamageDimensionsOverridePositive.get()).stream().map(ResourceLocation::new).map(s -> ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)s)).collect(Collectors.toUnmodifiableSet());
        this.configSettings = new ConfigSettings(levels, positiveLevels, biomes);
        this.reloadSettings();
    }

    @Override
    @Deprecated
    public boolean getSundamageInBiome(ResourceLocation registryName) {
        return !this.noSunDamageBiomes.contains(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)registryName));
    }

    @Override
    public boolean getSundamageInDim(ResourceKey<Level> dim) {
        if (this.sunDamageLevels.contains(dim)) {
            return true;
        }
        if (this.noSunDamageLevels.contains(dim)) {
            return false;
        }
        return (Boolean)VampirismConfig.SERVER.sundamageUnknownDimension.get();
    }

    @Override
    public boolean hasSunDamage(@NotNull LevelAccessor levelAccessor, @NotNull BlockPos pos) {
        DimensionType dimensionType = levelAccessor.m_6042_();
        ResourceKey<Level> level = this.getLevel(levelAccessor);
        if (this.registryAccess != null && this.registryAccess.m_6632_(Registries.f_256787_).flatMap(a -> a.m_7854_((Object)dimensionType)).filter(key -> this.noSunDamageDimensions.contains(key)).isPresent()) {
            return this.sunDamageLevels.contains(level);
        }
        if (this.noSunDamageLevels.contains(level)) {
            return false;
        }
        Holder biome = levelAccessor.m_204166_(pos);
        return biome.m_203543_().filter(key -> this.noSunDamageBiomes.contains(key)).isEmpty();
    }

    @Override
    @SafeVarargs
    public final void addNoSundamageBiomes(ResourceKey<Biome> ... biomes) {
        this.apiSettings.biomes.addAll(Arrays.asList(biomes));
    }

    @Override
    public void addNoSundamageDimensionType(ResourceKey<DimensionType> dimensionType) {
        this.apiSettings.dimensions.add(dimensionType);
    }

    @Override
    public boolean hasBiomeSundamage(ResourceKey<Biome> biome) {
        return false;
    }

    @Override
    public boolean hasDimensionTypeSundamage(ResourceKey<DimensionType> dimensionType) {
        return false;
    }

    private ResourceKey<Level> getLevel(LevelAccessor levelAccessor) {
        ResourceKey resourceKey;
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            resourceKey = level.m_46472_();
        } else if (levelAccessor instanceof WorldGenRegion) {
            WorldGenRegion worldGenRegion = (WorldGenRegion)levelAccessor;
            resourceKey = worldGenRegion.m_6018_().m_46472_();
        } else {
            resourceKey = Level.f_46428_;
        }
        return resourceKey;
    }

    @Override
    public boolean isGettingSundamage(LivingEntity entity, LevelAccessor world) {
        return Helper.gettingSundamge(entity, world, null);
    }

    @Override
    @Deprecated
    public void addNoSundamageBiomes(ResourceLocation ... biomes) {
        this.apiSettings.biomes.addAll(Arrays.stream(biomes).map(id -> ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)id)).toList());
    }

    @Override
    @Deprecated
    public void specifySundamageForDim(ResourceKey<Level> dimension, boolean sundamage) {
        if (sundamage) {
            this.apiSettings.sundamageLevels.add(dimension);
            this.apiSettings.levels.remove(dimension);
        } else {
            this.apiSettings.levels.add(dimension);
            this.apiSettings.sundamageLevels.remove(dimension);
        }
    }

    public void applyNetworkData(@NotNull ClientboundSundamagePacket msg) {
        this.noSunDamageBiomes = Set.copyOf(msg.biomes());
        this.noSunDamageDimensions = Set.copyOf(msg.dimensions());
        this.noSunDamageLevels = Set.copyOf(msg.noSunDamageLevels());
        this.sunDamageLevels = Set.copyOf(msg.sunDamageLevels());
    }

    public void initServer(RegistryAccess registryAccess) {
        this.registryAccess = registryAccess;
        this.reloadSettings();
    }

    public void removeServer() {
        this.registryAccess = null;
        this.reloadSettings();
    }

    public record Settings(HolderSet<Biome> biomesWithout, HolderSet<DimensionType> dimensionWithout, @Unmodifiable Set<ResourceKey<Level>> levelsWithoutSunDamage, @Unmodifiable Set<ResourceKey<Level>> levelsWithSunDamage) {
        private static final Settings EMPTY = new Settings((HolderSet<Biome>)HolderSet.m_205809_((Holder[])new Holder[0]), (HolderSet<DimensionType>)HolderSet.m_205809_((Holder[])new Holder[0]), Collections.emptySet(), Collections.emptySet());
    }

    public record APISettings(List<ResourceKey<Biome>> biomes, List<ResourceKey<DimensionType>> dimensions, List<ResourceKey<Level>> levels, List<ResourceKey<Level>> sundamageLevels) {
    }

    public record ConfigSettings(@Unmodifiable Set<ResourceKey<Level>> levels, @Unmodifiable Set<ResourceKey<Level>> sundamageLevels, @Unmodifiable Set<ResourceKey<Biome>> biomes) {
    }
}

