/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.vampirism.blocks.AlchemyTableBlock;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.inventory.AlchemyTableMenu;
import de.teamlapen.vampirism.util.OilUtils;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlchemyTableBlockEntity
extends BaseContainerBlockEntity {
    @NotNull
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
    private int brewTime;
    private boolean @Nullable [] lastOilCount;
    private Item ingredient;
    private int fuel;
    private int productColor;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int slotId) {
            return switch (slotId) {
                case 0 -> AlchemyTableBlockEntity.this.brewTime;
                case 1 -> AlchemyTableBlockEntity.this.fuel;
                case 2 -> AlchemyTableBlockEntity.this.productColor;
                default -> 0;
            };
        }

        public void m_8050_(int slotId, int value) {
            switch (slotId) {
                case 0: {
                    AlchemyTableBlockEntity.this.brewTime = value;
                    break;
                }
                case 1: {
                    AlchemyTableBlockEntity.this.fuel = value;
                    break;
                }
                case 2: {
                    AlchemyTableBlockEntity.this.productColor = value;
                }
            }
        }

        public int m_6499_() {
            return 3;
        }
    };

    public AlchemyTableBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        super((BlockEntityType)ModTiles.ALCHEMICAL_TABLE.get(), pos, state);
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.vampirism.alchemy_table");
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int menuId, @NotNull Inventory playerInventory) {
        return new AlchemyTableMenu(menuId, this.f_58857_, playerInventory, (Container)this, this.dataAccess);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean[] getPotionBits() {
        boolean[] aboolean = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            aboolean[i] = true;
        }
        return aboolean;
    }

    @NotNull
    public ItemStack m_8020_(int p_70301_1_) {
        return p_70301_1_ >= 0 && p_70301_1_ < this.items.size() ? (ItemStack)this.items.get(p_70301_1_) : ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack m_7407_(int p_70298_1_, int p_70298_2_) {
        return ContainerHelper.m_18969_(this.items, (int)p_70298_1_, (int)p_70298_2_);
    }

    @NotNull
    public ItemStack m_8016_(int p_70304_1_) {
        return ContainerHelper.m_18966_(this.items, (int)p_70304_1_);
    }

    public void m_6836_(int p_70299_1_, @NotNull ItemStack stack) {
        if (p_70299_1_ >= 0 && p_70299_1_ < this.items.size()) {
            this.items.set(p_70299_1_, (Object)stack);
        }
    }

    public boolean m_6542_(@NotNull Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public static void serverTick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull AlchemyTableBlockEntity blockEntity) {
        ItemStack itemstack = (ItemStack)blockEntity.items.get(5);
        if (blockEntity.fuel <= 0 && itemstack.m_41720_() == Items.f_42593_) {
            blockEntity.fuel = 20;
            itemstack.m_41774_(1);
            blockEntity.m_6596_();
        }
        boolean flag = blockEntity.isBrewable(level);
        boolean flag1 = blockEntity.brewTime > 0;
        ItemStack itemstack1 = (ItemStack)blockEntity.items.get(4);
        if (flag1) {
            boolean flag2;
            --blockEntity.brewTime;
            boolean bl = flag2 = blockEntity.brewTime == 0;
            if (flag2 && flag) {
                blockEntity.doBrew(level);
                blockEntity.m_6596_();
            } else if (!flag) {
                blockEntity.brewTime = 0;
                blockEntity.m_6596_();
            } else if (blockEntity.ingredient != itemstack1.m_41720_()) {
                blockEntity.brewTime = 0;
                blockEntity.m_6596_();
            }
        } else if (flag && blockEntity.fuel > 0) {
            --blockEntity.fuel;
            blockEntity.brewTime = 600;
            blockEntity.ingredient = itemstack1.m_41720_();
            blockEntity.productColor = level.m_7465_().m_44013_((RecipeType)ModRecipes.ALCHEMICAL_TABLE_TYPE.get()).stream().filter(recipe -> recipe.isInput((ItemStack)blockEntity.items.get(4)) && (recipe.isIngredient((ItemStack)blockEntity.items.get(0)) || recipe.isIngredient((ItemStack)blockEntity.items.get(1)))).map(recipe -> recipe.m_8043_(level.m_9598_())).map(s -> OilUtils.getOil(s).getColor()).findAny().orElse(0xFFFFFF);
            blockEntity.m_6596_();
        }
        boolean[] aboolean = blockEntity.getPotionBits();
        if (!Arrays.equals(aboolean, blockEntity.lastOilCount)) {
            blockEntity.lastOilCount = aboolean;
            if (!(state.m_60734_() instanceof AlchemyTableBlock)) {
                return;
            }
            state = (BlockState)state.m_61124_((Property)AlchemyTableBlock.HAS_BOTTLE_INPUT_0, (Comparable)Boolean.valueOf(aboolean[0]));
            state = (BlockState)state.m_61124_((Property)AlchemyTableBlock.HAS_BOTTLE_INPUT_1, (Comparable)Boolean.valueOf(aboolean[1]));
            state = (BlockState)state.m_61124_((Property)AlchemyTableBlock.HAS_BOTTLE_OUTPUT_0, (Comparable)Boolean.valueOf(aboolean[2]));
            state = (BlockState)state.m_61124_((Property)AlchemyTableBlock.HAS_BOTTLE_OUTPUT_1, (Comparable)Boolean.valueOf(aboolean[3]));
            level.m_7731_(pos, state, 2);
        }
    }

    private boolean isBrewable(@NotNull Level level) {
        ItemStack itemstack = (ItemStack)this.items.get(4);
        if (itemstack.m_41619_()) {
            return false;
        }
        if (!this.isValidInput(level, itemstack)) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            ItemStack itemstack1;
            if (!((ItemStack)this.items.get(i + 2)).m_41619_() || (itemstack1 = (ItemStack)this.items.get(i)).m_41619_() || !this.hasRecipe(level, itemstack, itemstack1)) continue;
            return true;
        }
        return false;
    }

    private void doBrew(@NotNull Level level) {
        ItemStack itemstack = (ItemStack)this.items.get(4);
        for (int i = 0; i < 2; ++i) {
            if (!((ItemStack)this.items.get(i + 2)).m_41619_()) continue;
            ItemStack stack = this.getOutput(level, itemstack, (ItemStack)this.items.get(i));
            this.items.set(i, (Object)ItemStack.f_41583_);
            this.items.set(i + 2, (Object)stack);
        }
        BlockPos blockpos = this.m_58899_();
        if (itemstack.hasCraftingRemainingItem()) {
            ItemStack itemstack1 = itemstack.getCraftingRemainingItem();
            itemstack.m_41774_(1);
            if (itemstack.m_41619_()) {
                itemstack = itemstack1;
            } else if (!level.f_46443_) {
                Containers.m_18992_((Level)level, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), (ItemStack)itemstack1);
            }
        } else {
            itemstack.m_41774_(1);
        }
        this.items.set(4, (Object)itemstack);
        level.m_46796_(1035, blockpos, 0);
    }

    public boolean m_7013_(int p_94041_1_, @NotNull ItemStack stack) {
        if (p_94041_1_ == 3) {
            return this.isValidIngredient(this.f_58857_, stack);
        }
        Item item = stack.m_41720_();
        if (p_94041_1_ == 4) {
            return item == Items.f_42593_;
        }
        return this.isValidInput(this.f_58857_, stack) && this.m_8020_(p_94041_1_).m_41619_();
    }

    private boolean hasRecipe(@NotNull Level level, @NotNull ItemStack input, @NotNull ItemStack ingredient) {
        return level.m_7465_().m_44013_((RecipeType)ModRecipes.ALCHEMICAL_TABLE_TYPE.get()).stream().anyMatch(recipe -> recipe.isInput(input) && recipe.isIngredient(ingredient));
    }

    public boolean isValidIngredient(@NotNull Level level, @NotNull ItemStack stack) {
        return level.m_7465_().m_44013_((RecipeType)ModRecipes.ALCHEMICAL_TABLE_TYPE.get()).stream().anyMatch(recipe -> recipe.isIngredient(stack));
    }

    public boolean isValidInput(@NotNull Level level, @NotNull ItemStack stack) {
        return level.m_7465_().m_44013_((RecipeType)ModRecipes.ALCHEMICAL_TABLE_TYPE.get()).stream().anyMatch(recipe -> recipe.isInput(stack));
    }

    @NotNull
    public ItemStack getOutput(@NotNull Level level, @NotNull ItemStack input, @NotNull ItemStack ingredient) {
        return level.m_7465_().m_44013_((RecipeType)ModRecipes.ALCHEMICAL_TABLE_TYPE.get()).stream().map(recipe -> recipe.getResult(input, ingredient)).filter(a -> !a.m_41619_()).findFirst().orElse(ItemStack.f_41583_);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.brewTime = tag.m_128448_("BrewTime");
        this.fuel = tag.m_128445_("Fuel");
    }

    public void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128376_("BrewTime", (short)this.brewTime);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128344_("Fuel", (byte)this.fuel);
    }
}

