/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.vampiresneedumbrellas.handlers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class CuriosHandler {
    public static void onBrokenCurio(String id, int index, Player consumer) {
        CuriosApi.broadcastCurioBreakEvent((SlotContext)new SlotContext(id, (LivingEntity)consumer, index, false, false));
    }

    public static Optional<SlotResult> getUmbrellaEquiped(ItemStack umbrella, Player player) {
        Optional inventory = CuriosApi.getCuriosInventory((LivingEntity)player).resolve();
        if (inventory.isPresent()) {
            return ((ICuriosItemHandler)inventory.get()).findFirstCurio(umbrella.m_41720_());
        }
        return Optional.empty();
    }

    public static ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt, final UUID SPEED_ATTRIBUTE, final double speed) {
        return new ICapabilityProvider(){
            private final LazyOptional<ICurio> lazyCurio = LazyOptional.of(() -> new ICurio(){

                public ItemStack getStack() {
                    return stack;
                }

                public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid) {
                    HashMultimap attributes = HashMultimap.create();
                    if (speed != 0.0) {
                        attributes.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(SPEED_ATTRIBUTE, "Umbrella Speed Modifier", speed, AttributeModifier.Operation.MULTIPLY_BASE));
                    }
                    return attributes;
                }

                public List<Component> getAttributesTooltip(List<Component> tooltips) {
                    tooltips.clear();
                    return tooltips;
                }
            });

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(capability, this.lazyCurio);
            }
        };
    }
}

