/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.data.recipe;

import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.data.recipebuilder.AlchemyTableRecipeBuilder;
import de.teamlapen.vampirism.data.recipebuilder.ShapedWeaponTableRecipeBuilder;
import de.teamlapen.vampirism.data.recipebuilder.ShapelessWeaponTableRecipeBuilder;
import de.teamlapen.vampirism.util.NBTIngredient;
import java.util.Arrays;
import java.util.function.Consumer;
import net.grid.vampiresdelight.common.registry.VDBlocks;
import net.grid.vampiresdelight.common.registry.VDItems;
import net.grid.vampiresdelight.common.registry.VDOils;
import net.grid.vampiresdelight.common.registry.VDPotions;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class VDVampirismRecipes {
    public static void register(Consumer<FinishedRecipe> consumer) {
        VDVampirismRecipes.recipesWeaponTable(consumer);
        VDVampirismRecipes.recipesAlchemyTable(consumer);
    }

    private static void recipesWeaponTable(Consumer<FinishedRecipe> consumer) {
        ShapelessWeaponTableRecipeBuilder.shapelessWeaponTable((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)VDItems.ALCHEMICAL_COCKTAIL.get())).requires((ItemLike)Items.f_42590_).requires((ItemLike)ModItems.ITEM_ALCHEMICAL_FIRE.get(), 2).unlockedBy("has_alchemical_fire", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ITEM_ALCHEMICAL_FIRE.get()})).m_176498_(consumer);
        ShapedWeaponTableRecipeBuilder.shapedWeaponTable((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)VDBlocks.SPIRIT_LANTERN.get())).pattern(" gg ").pattern("gssg").pattern("gssg").pattern(" gg ").define(Character.valueOf('g'), (ItemLike)Items.f_42587_).define(Character.valueOf('s'), (ItemLike)ModItems.SOUL_ORB_VAMPIRE.get()).unlockedBy("has_vampire_soul", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SOUL_ORB_VAMPIRE.get()})).m_176498_(consumer);
    }

    private static void recipesAlchemyTable(Consumer<FinishedRecipe> consumer) {
        AlchemyTableRecipeBuilder.builder(VDOils.BLESSING).bloodOilIngredient().input(VDVampirismRecipes.potion((Potion)VDPotions.BLESSING.get(), (Potion)VDPotions.STRONG_BLESSING.get(), (Potion)VDPotions.LONG_BLESSING.get())).build(consumer, new ResourceLocation("vampiresdelight", "blessing_oil"));
        AlchemyTableRecipeBuilder.builder(VDOils.CLOTHES_DISSOLVING).bloodOilIngredient().input(VDVampirismRecipes.potion((Potion)VDPotions.CLOTHES_DISSOLVING.get())).build(consumer, new ResourceLocation("vampiresdelight", "clothes_dissolving_oil"));
        AlchemyTableRecipeBuilder.builder(VDOils.FOG_VISION).bloodOilIngredient().input(VDVampirismRecipes.potion((Potion)VDPotions.FOG_VISION.get(), (Potion)VDPotions.STRONG_FOG_VISION.get(), (Potion)VDPotions.LONG_FOG_VISION.get())).build(consumer, new ResourceLocation("vampiresdelight", "fog_vision_oil"));
    }

    @NotNull
    private static Ingredient potion(Potion ... potion) {
        return new NBTIngredient((ItemStack[])Arrays.stream(potion).map(p -> PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_, 1), (Potion)p)).toArray(ItemStack[]::new));
    }
}

