/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.data;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.grid.vampiresdelight.common.registry.VDLootTables;
import net.grid.vampiresdelight.data.VDAdvancements;
import net.grid.vampiresdelight.data.VDBiomeTags;
import net.grid.vampiresdelight.data.VDBlockModels;
import net.grid.vampiresdelight.data.VDBlockStates;
import net.grid.vampiresdelight.data.VDBlockTags;
import net.grid.vampiresdelight.data.VDEntityTags;
import net.grid.vampiresdelight.data.VDItemModels;
import net.grid.vampiresdelight.data.VDItemTags;
import net.grid.vampiresdelight.data.VDRecipes;
import net.grid.vampiresdelight.data.VDRegistrySets;
import net.grid.vampiresdelight.data.loot.VDBlockLootTables;
import net.grid.vampiresdelight.data.loot.VDChestLootTables;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="vampiresdelight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class VDDataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        VDBlockTags blockTags = new VDBlockTags(output, lookupProvider, helper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new VDRecipes(output));
        generator.addProvider(event.includeServer(), (DataProvider)new VDAdvancements(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new VDRegistrySets(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new VDItemTags(output, lookupProvider, blockTags.m_274426_(), helper));
        generator.addProvider(event.includeServer(), (DataProvider)new VDBiomeTags(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new VDEntityTags(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, VDLootTables.getLootTables(), List.of(new LootTableProvider.SubProviderEntry(VDBlockLootTables::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(VDChestLootTables::new, LootContextParamSets.f_81411_))));
        generator.addProvider(event.includeClient(), (DataProvider)new VDBlockModels(output, helper));
        VDBlockStates blockStates = new VDBlockStates(output, helper);
        generator.addProvider(event.includeClient(), (DataProvider)blockStates);
        generator.addProvider(event.includeClient(), (DataProvider)new VDItemModels(output, blockStates.models().existingFileHelper));
    }
}

