/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.data;

import de.teamlapen.vampirism.core.ModBlocks;
import java.util.Objects;
import net.grid.vampiresdelight.common.block.BarStoolBlock;
import net.grid.vampiresdelight.common.registry.VDBlocks;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class VDBlockModels
extends BlockModelProvider {
    public VDBlockModels(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "vampiresdelight", existingFileHelper);
    }

    private String blockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    protected void registerModels() {
        this.pieBlock((Block)VDBlocks.BLOOD_PIE.get());
        this.wineShelfBlock((Block)VDBlocks.OAK_WINE_SHELF.get(), Blocks.f_50705_);
        this.wineShelfBlock((Block)VDBlocks.SPRUCE_WINE_SHELF.get(), Blocks.f_50741_);
        this.wineShelfBlock((Block)VDBlocks.BIRCH_WINE_SHELF.get(), Blocks.f_50742_);
        this.wineShelfBlock((Block)VDBlocks.JUNGLE_WINE_SHELF.get(), Blocks.f_50743_);
        this.wineShelfBlock((Block)VDBlocks.ACACIA_WINE_SHELF.get(), Blocks.f_50744_);
        this.wineShelfBlock((Block)VDBlocks.DARK_OAK_WINE_SHELF.get(), Blocks.f_50745_);
        this.wineShelfBlock((Block)VDBlocks.MANGROVE_WINE_SHELF.get(), Blocks.f_220865_);
        this.wineShelfBlock((Block)VDBlocks.CHERRY_WINE_SHELF.get(), Blocks.f_271304_);
        this.wineShelfBlock((Block)VDBlocks.BAMBOO_WINE_SHELF.get(), Blocks.f_244477_);
        this.wineShelfBlock((Block)VDBlocks.CRIMSON_WINE_SHELF.get(), Blocks.f_50655_);
        this.wineShelfBlock((Block)VDBlocks.WARPED_WINE_SHELF.get(), Blocks.f_50656_);
        this.wineShelfBlock((Block)VDBlocks.CURSED_SPRUCE_WINE_SHELF.get(), (Block)ModBlocks.CURSED_SPRUCE_PLANKS.get(), "vampirism");
        this.wineShelfBlock((Block)VDBlocks.DARK_SPRUCE_WINE_SHELF.get(), (Block)ModBlocks.DARK_SPRUCE_PLANKS.get(), "vampirism");
        BarStoolBlock.getBarStoolBlocks().forEach(this::barStoolBlock);
        this.farmlandBlock((Block)VDBlocks.CURSED_FARMLAND.get(), (Block)ModBlocks.CURSED_EARTH.get(), false, true);
        this.farmlandBlock((Block)VDBlocks.BLOODY_SOIL_FARMLAND.get(), (Block)VDBlocks.BLOODY_SOIL.get(), true, false);
        this.hugeBlackMushroomBlock((Block)VDBlocks.BLACK_MUSHROOM_BLOCK.get());
        this.hugeBlackMushroomBlock((Block)VDBlocks.BLACK_MUSHROOM_STEM.get());
        this.hugeBlackMushroomBlock("black_mushroom_block_inside");
    }

    private void pieBlock(Block pieBlock) {
        String pieBlockName = this.blockName(pieBlock);
        this.pieBlockPart(pieBlockName, "");
        this.pieBlockPart(pieBlockName, "_slice1");
        this.pieBlockPart(pieBlockName, "_slice2");
        this.pieBlockPart(pieBlockName, "_slice3");
    }

    private void pieBlockPart(String pieBlockName, String suffix) {
        ResourceLocation topTexture = this.resourceBlock(pieBlockName + "_top");
        ResourceLocation innerTexture = this.resourceBlock(pieBlockName + "_inner");
        if (Objects.equals(suffix, "")) {
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(pieBlockName + suffix, "farmersdelight:block/pie" + suffix)).texture("particle", topTexture)).texture("bottom", new ResourceLocation("farmersdelight", "block/pie_bottom"))).texture("side", new ResourceLocation("farmersdelight", "block/pie_side"))).texture("top", topTexture);
        } else {
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(pieBlockName + suffix, "farmersdelight:block/pie" + suffix)).texture("particle", topTexture)).texture("bottom", new ResourceLocation("farmersdelight", "block/pie_bottom"))).texture("inner", innerTexture)).texture("side", new ResourceLocation("farmersdelight", "block/pie_side"))).texture("top", topTexture);
        }
    }

    private void wineShelfBlock(Block shelfBlock, Block woodType) {
        this.wineShelfBlock(shelfBlock, woodType, "minecraft");
    }

    private void wineShelfBlock(Block shelfBlock, Block woodType, String nameSpace) {
        ResourceLocation shelfTexture = this.resourceBlock(this.blockName(shelfBlock));
        ResourceLocation woodTypeTexture = new ResourceLocation(nameSpace, "block/" + this.blockName(woodType));
        String name = this.blockName(shelfBlock);
        ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(name, "vampiresdelight:block/template_wine_shelf")).texture("particle", woodTypeTexture)).texture("body", shelfTexture);
        ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(name + "_support", "vampiresdelight:block/template_wine_shelf_support")).texture("particle", woodTypeTexture)).texture("body", shelfTexture);
    }

    private void barStoolBlock(Block barStool) {
        ResourceLocation seatTexture = this.resourceBlock(this.blockName(barStool) + "_seat");
        String name = this.blockName(barStool);
        ((BlockModelBuilder)this.withExistingParent(name, "vampiresdelight:block/template_bar_stool")).texture("seat", seatTexture);
    }

    private void farmlandBlock(Block farmlandBlock, Block soilBlock, boolean needsSpecialSide, boolean vampirismSoilBlock) {
        String name = this.blockName(farmlandBlock);
        String soilBlockModId = vampirismSoilBlock ? "vampirism" : "vampiresdelight";
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(name, "farmersdelight:block/template_farmland_custom")).texture("top", this.resourceBlock(this.blockName(farmlandBlock)))).texture("bottom", this.resourceBlock(soilBlockModId, this.blockName(soilBlock)))).texture("side", this.resourceBlock(soilBlockModId, this.blockName(soilBlock)));
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(name + "_moist", "farmersdelight:block/template_farmland_custom")).texture("top", this.resourceBlock(this.blockName(farmlandBlock) + "_moist"))).texture("bottom", this.resourceBlock(soilBlockModId, this.blockName(soilBlock)))).texture("side", this.resourceBlock(soilBlockModId, (String)(needsSpecialSide ? this.blockName(farmlandBlock) + "_moist_side" : this.blockName(soilBlock))));
    }

    private void hugeBlackMushroomBlock(String name, ResourceLocation texture, boolean needsInventoryVersion) {
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(name)).texture("texture", texture)).texture("particle", texture)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 0.0f).face(Direction.NORTH).texture("#texture").cullface(Direction.NORTH);
        if (needsInventoryVersion) {
            this.cubeAll(name + "_inventory", texture);
        }
    }

    private void hugeBlackMushroomBlock(Block block) {
        this.hugeBlackMushroomBlock(this.blockName(block), this.resourceBlock(this.blockName(block)), true);
    }

    private void hugeBlackMushroomBlock(String path) {
        this.hugeBlackMushroomBlock(path, this.resourceBlock(path), false);
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("vampiresdelight", "block/" + path);
    }

    public ResourceLocation resourceBlock(String namespace, String path) {
        return new ResourceLocation(namespace, "block/" + path);
    }
}

