/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.registry;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class VDLootTables {
    private static final Set<ResourceLocation> LOOT_TABLES = Sets.newHashSet();
    public static final ResourceLocation CHEST_LOST_CARRIAGE = VDLootTables.register("chests/lost_carriage");

    @NotNull
    static ResourceLocation register(@NotNull String resourceName) {
        return VDLootTables.register(new ResourceLocation("vampiresdelight", resourceName));
    }

    @NotNull
    static ResourceLocation register(@NotNull ResourceLocation resourceLocation) {
        LOOT_TABLES.add(resourceLocation);
        return resourceLocation;
    }

    @NotNull
    public static Set<ResourceLocation> getLootTables() {
        return ImmutableSet.copyOf(LOOT_TABLES);
    }
}

