/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.item;

import java.util.List;
import java.util.function.Consumer;
import net.grid.vampiresdelight.client.extension.PourableBottleItemExtension;
import net.grid.vampiresdelight.common.block.PlacedPourableBottleBlock;
import net.grid.vampiresdelight.common.item.ICustomUseItem;
import net.grid.vampiresdelight.common.registry.VDAdvancementTriggers;
import net.grid.vampiresdelight.common.registry.VDSounds;
import net.grid.vampiresdelight.common.utility.VDTextUtils;
import net.grid.vampiresdelight.common.utility.VDTooltipUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PourableBottleItem
extends Item
implements ICustomUseItem {
    private final PlacedPourableBottleBlock placedBottleBlock;
    private final Item serving;
    private final Item servingContainer;

    public PourableBottleItem(Item.Properties properties, PlacedPourableBottleBlock placedBottleBlock, Item serving, Item servingContainer, int servings) {
        super(properties.m_41499_(servings).setNoRepair());
        this.placedBottleBlock = placedBottleBlock;
        this.serving = serving;
        this.servingContainer = servingContainer;
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand mainHand) {
        BlockHitResult hitResult = PourableBottleItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        InteractionHand offHand = mainHand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack pouringBottle = player.m_21120_(mainHand);
        ItemStack glassBottle = player.m_21120_(offHand);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK && player.m_6047_()) {
            BlockPos blockPos = hitResult.m_82425_();
            BlockPos targetPos = player.m_6047_() ? blockPos.m_121945_(hitResult.m_82434_()) : blockPos;
            BlockState targetState = level.m_8055_(targetPos);
            BlockState bottleBlockToPlace = this.placedBottleBlock.m_5573_(new BlockPlaceContext(level, player, mainHand, pouringBottle, hitResult));
            if (targetState.m_247087_() && bottleBlockToPlace != null) {
                level.m_7731_(targetPos, bottleBlockToPlace, 3);
                bottleBlockToPlace.m_60734_().m_6402_(level, targetPos, bottleBlockToPlace, (LivingEntity)player, pouringBottle);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, targetPos, pouringBottle);
                }
                SoundType soundtype = bottleBlockToPlace.getSoundType((LevelReader)level, targetPos, (Entity)player);
                level.m_5594_(player, targetPos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                level.m_220407_(GameEvent.f_157797_, targetPos, GameEvent.Context.m_223719_((Entity)player, (BlockState)bottleBlockToPlace));
                if (!player.m_150110_().f_35937_) {
                    pouringBottle.m_41774_(1);
                }
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)pouringBottle);
            }
        }
        if (pouringBottle.m_41784_().m_128441_("Pouring")) {
            player.m_6672_(mainHand);
            return new InteractionResultHolder(InteractionResult.PASS, (Object)pouringBottle);
        }
        if (glassBottle.m_41720_() == this.servingContainer) {
            ItemStack itemUsed = glassBottle.m_41777_();
            ItemStack toPour = itemUsed.m_41620_(1);
            player.m_6672_(mainHand);
            pouringBottle.m_41784_().m_128365_("Pouring", (Tag)toPour.serializeNBT());
            player.m_21008_(offHand, itemUsed);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)pouringBottle);
        }
        Vec3 POVHit = hitResult.m_82450_();
        AABB aabb = new AABB(POVHit, POVHit).m_82400_(1.0);
        ItemEntity pickUp = null;
        for (ItemEntity itemEntity : level.m_45976_(ItemEntity.class, aabb)) {
            if (!itemEntity.m_6084_() && itemEntity.m_20182_().m_82554_(player.m_20182_()) > 3.0 && !itemEntity.m_6084_() && itemEntity.m_32055_().m_41720_() != this.servingContainer) continue;
            pickUp = itemEntity;
            break;
        }
        if (pickUp != null) {
            ItemStack pickedItem = pickUp.m_32055_().m_41777_();
            ItemStack toPour = pickedItem.m_41620_(1);
            player.m_6672_(mainHand);
            if (!level.f_46443_) {
                pouringBottle.m_41784_().m_128365_("Pouring", (Tag)toPour.serializeNBT());
                if (pickedItem.m_41619_()) {
                    pickUp.m_146870_();
                } else {
                    pickUp.m_32045_(pickedItem);
                }
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)pouringBottle);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)pouringBottle);
    }

    public ItemStack m_5922_(ItemStack itemStack, Level level, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return itemStack;
        }
        Player player = (Player)entity;
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_("Pouring")) {
            if (player instanceof FakePlayer) {
                player.m_7197_(new ItemStack((ItemLike)this.serving), false, false);
            } else {
                player.m_150109_().m_150079_(new ItemStack((ItemLike)this.serving));
            }
            compoundTag.m_128473_("Pouring");
            VDAdvancementTriggers.DRINK_POURED.trigger((ServerPlayer)player, itemStack);
            entity.m_5496_((SoundEvent)VDSounds.POURING_FINISH.get(), 1.2f, 1.0f);
            itemStack.m_41721_(itemStack.m_41773_() + 1);
            if (itemStack.m_41773_() >= itemStack.m_41776_()) {
                itemStack = new ItemStack((ItemLike)this.servingContainer);
            }
        }
        return itemStack;
    }

    public void m_5551_(ItemStack itemStack, Level level, LivingEntity entity, int durationTime) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_("Pouring")) {
            player.m_150109_().m_150079_(ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("Pouring")));
            entity.m_5496_((SoundEvent)VDSounds.POURING_FINISH.get(), 1.2f, 1.0f);
            compoundTag.m_128473_("Pouring");
        }
    }

    @Override
    public boolean hasCustomUseEffects() {
        return true;
    }

    @Override
    public boolean triggerUseEffects(ItemStack stack, LivingEntity entity, int amount) {
        if ((entity.m_21252_() - 6) % 7 == 0) {
            entity.m_5496_((SoundEvent)VDSounds.POURING_SHORT.get(), 1.2f, entity.m_217043_().m_188501_() * 0.2f + 0.9f + (float)entity.m_21252_() / 128.0f);
        }
        return true;
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        ItemStack item = itemStack.m_41777_();
        item.m_41721_(item.m_41773_() + 1);
        if (item.m_41773_() > 3) {
            return new ItemStack((ItemLike)this.servingContainer);
        }
        return item;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        int servings = stack.m_41776_() - stack.m_41773_();
        MutableComponent textTooltip = VDTextUtils.getTranslation("tooltip." + this + (servings == 1 ? ".single_serving" : ".multiple_servings"), servings);
        tooltip.add((Component)textTooltip.m_130940_(ChatFormatting.GRAY));
        VDTooltipUtils.addShiftTooltip("tooltip.pourable_drink_item", tooltip);
    }

    @NotNull
    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.DRINK;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new PourableBottleItemExtension());
    }
}

