/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.item;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.config.VampirismConfig;
import java.util.List;
import net.grid.vampiresdelight.common.constants.VDFoodFeatures;
import net.grid.vampiresdelight.common.constants.VDFoodValues;
import net.grid.vampiresdelight.common.item.VampireDrinkableItem;
import net.grid.vampiresdelight.common.registry.VDItems;
import net.grid.vampiresdelight.common.utility.VDHelper;
import net.grid.vampiresdelight.common.utility.VDTextUtils;
import net.grid.vampiresdelight.common.utility.VDTooltipUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.Configuration;

public class OrchidTeaItem
extends VampireDrinkableItem {
    public OrchidTeaItem() {
        super(VDItems.drinkItem(VDFoodValues.ORCHID_TEA_HUMAN), VDFoodValues.ORCHID_TEA_VAMPIRE, VDFoodValues.ORCHID_TEA_IMMUNE, VDFoodFeatures.ORCHID_TEA);
    }

    @Override
    @Nullable
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        Player player;
        if (entity == null) {
            entity = VampirismMod.proxy.getClientPlayer();
        }
        return VDHelper.isVampire((Entity)entity) ? this.getVampireFood() : (entity instanceof Player && VDHelper.canBeInfectedFromItem(player = (Player)entity) ? super.getFoodProperties(stack, entity) : this.getHunterFood());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        Player player = VampirismMod.proxy.getClientPlayer();
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            if (player != null && VDHelper.canBecomeVampire((Player)player) && !((Boolean)VampirismConfig.SERVER.disableFangInfection.get()).booleanValue()) {
                MutableComponent textEmpty = VDTextUtils.getTranslation("tooltip." + this, new Object[0]);
                tooltip.add((Component)textEmpty.m_130940_(ChatFormatting.BLUE));
            } else {
                VDTextUtils.addFoodEffectTooltip(stack, (LivingEntity)player, tooltip);
            }
        }
        if (player != null) {
            VDTooltipUtils.addFactionFoodToolTips(tooltip, player, VReference.VAMPIRE_FACTION);
        }
    }
}

