/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.entity;

import de.teamlapen.vampirism.blocks.AlchemicalFireBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.grid.vampiresdelight.common.VDConfiguration;
import net.grid.vampiresdelight.common.item.AlchemicalCocktailItem;
import net.grid.vampiresdelight.common.registry.VDEntityTypes;
import net.grid.vampiresdelight.common.registry.VDItems;
import net.grid.vampiresdelight.common.registry.VDSounds;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class AlchemicalCocktailEntity
extends ThrowableItemProjectile {
    public AlchemicalCocktailEntity(EntityType<? extends AlchemicalCocktailEntity> entityType, Level level) {
        super(entityType, level);
    }

    public AlchemicalCocktailEntity(Level level, LivingEntity entity) {
        super((EntityType)VDEntityTypes.ALCHEMICAL_COCKTAIL.get(), entity, level);
    }

    public AlchemicalCocktailEntity(Level level, double x, double y, double z) {
        super((EntityType)VDEntityTypes.ALCHEMICAL_COCKTAIL.get(), x, y, z, level);
    }

    protected Item m_7881_() {
        return (Item)VDItems.ALCHEMICAL_COCKTAIL.get();
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        entity.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), 0.0f);
        entity.m_20254_(16);
        this.setOnFire((HitResult)result);
        this.playLandingSound();
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.setOnFire(result);
            this.playLandingSound();
            this.m_146870_();
        }
    }

    private void setOnFire(HitResult result) {
        if (((Boolean)VDConfiguration.ALCHEMICAL_COCKTAIL_BURNS_GROUND.get()).booleanValue() && !this.m_9236_().f_46443_) {
            BlockPos blockPos = BlockPos.m_274446_((Position)result.m_82450_());
            double radius = (Double)VDConfiguration.ALCHEMICAL_COCKTAIL_SPLASH_RADIUS.get();
            int dx = (int)(-Math.ceil(radius));
            while ((double)dx <= radius) {
                int dz = (int)(-Math.ceil(radius));
                while ((double)dz <= radius) {
                    double distance = Math.sqrt(dx * dx + dz * dz);
                    if (!(distance > radius)) {
                        for (int dy = -2; dy < 2; ++dy) {
                            BlockPos pos = blockPos.m_7918_(dx, dy, dz);
                            BlockState blockState = this.m_9236_().m_8055_(pos);
                            BlockState blockStateBelow = this.m_9236_().m_8055_(pos.m_7495_());
                            Random random = new Random();
                            double probability = (radius - distance) / radius;
                            if (!blockState.m_247087_() || !AlchemicalCocktailEntity.isProperBlockBelow(blockStateBelow, pos.m_7495_(), this.m_9236_()) || !(random.nextDouble() < probability)) continue;
                            this.m_9236_().m_46597_(pos, ((AlchemicalFireBlock)ModBlocks.ALCHEMICAL_FIRE.get()).m_49966_());
                        }
                    }
                    ++dz;
                }
                ++dx;
            }
        }
    }

    private static boolean isProperBlockBelow(BlockState blockStateBelow, BlockPos posBelow, Level level) {
        Block blockBelow = blockStateBelow.m_60734_();
        return blockStateBelow.m_60783_((BlockGetter)level, posBelow, Direction.UP) || blockStateBelow.m_204336_(BlockTags.f_13035_) || blockBelow instanceof StairBlock;
    }

    private void playLandingSound() {
        if (this.isMetalPipe()) {
            this.m_5496_((SoundEvent)VDSounds.METAL_PIPE.get(), 2.0f, this.f_19796_.m_188501_() * 0.1f + 1.0f);
        } else {
            this.m_5496_(SoundEvents.f_11983_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
        }
    }

    private boolean isMetalPipe() {
        return AlchemicalCocktailItem.isMetalPipe(this.m_7846_());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float m_7139_() {
        return 0.1f;
    }
}

