/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.block;

import de.teamlapen.lib.lib.util.UtilLib;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.grid.vampiresdelight.common.block.entity.WineShelfBlockEntity;
import net.grid.vampiresdelight.common.tag.VDTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WineShelfBlock
extends BaseEntityBlock {
    public static final BooleanProperty HAS_UPPER_SUPPORT = BooleanProperty.m_61465_((String)"has_upper_support");
    public static final EnumProperty<Slot> WINE_SHELF_SLOT_0 = EnumProperty.m_61587_((String)"slot_0", Slot.class);
    public static final EnumProperty<Slot> WINE_SHELF_SLOT_1 = EnumProperty.m_61587_((String)"slot_1", Slot.class);
    public static final EnumProperty<Slot> WINE_SHELF_SLOT_2 = EnumProperty.m_61587_((String)"slot_2", Slot.class);
    public static final EnumProperty<Slot> WINE_SHELF_SLOT_3 = EnumProperty.m_61587_((String)"slot_3", Slot.class);
    public static final List<EnumProperty<Slot>> SLOT_CONTENTS = List.of(WINE_SHELF_SLOT_0, WINE_SHELF_SLOT_1, WINE_SHELF_SLOT_2, WINE_SHELF_SLOT_3);

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)) {
            case Direction.EAST -> UtilLib.rotateShape((VoxelShape)WineShelfBlock.makeShape((Boolean)state.m_61143_((Property)HAS_UPPER_SUPPORT)), (UtilLib.RotationAmount)UtilLib.RotationAmount.NINETY);
            case Direction.SOUTH -> UtilLib.rotateShape((VoxelShape)WineShelfBlock.makeShape((Boolean)state.m_61143_((Property)HAS_UPPER_SUPPORT)), (UtilLib.RotationAmount)UtilLib.RotationAmount.HUNDRED_EIGHTY);
            case Direction.WEST -> UtilLib.rotateShape((VoxelShape)WineShelfBlock.makeShape((Boolean)state.m_61143_((Property)HAS_UPPER_SUPPORT)), (UtilLib.RotationAmount)UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);
            default -> WineShelfBlock.makeShape((Boolean)state.m_61143_((Property)HAS_UPPER_SUPPORT));
        };
    }

    public WineShelfBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(1.5f));
        BlockState blockstate = (BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)HAS_UPPER_SUPPORT, (Comparable)Boolean.valueOf(false));
        for (EnumProperty<Slot> enumProperty : SLOT_CONTENTS) {
            blockstate = (BlockState)blockstate.m_61124_(enumProperty, (Comparable)((Object)Slot.EMPTY));
        }
        this.m_49959_(blockstate);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos posAbove = context.m_8083_().m_7494_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)HAS_UPPER_SUPPORT, (Comparable)Boolean.valueOf(world.m_8055_(posAbove).m_60734_() instanceof WineShelfBlock));
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos blockPos, @NotNull BlockPos facingPos) {
        return super.m_7417_((BlockState)state.m_61124_((Property)HAS_UPPER_SUPPORT, (Comparable)Boolean.valueOf(level.m_8055_(blockPos.m_7494_()).m_60734_() instanceof WineShelfBlock)), facing, facingState, level, blockPos, facingPos);
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HorizontalDirectionalBlock.f_54117_, HAS_UPPER_SUPPORT});
        SLOT_CONTENTS.forEach(xva$0 -> builder.m_61104_(new Property[]{xva$0}));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level pLevel, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        BlockEntity blockEntity = pLevel.m_7702_(pos);
        if (blockEntity instanceof WineShelfBlockEntity) {
            WineShelfBlockEntity wineshelfblockentity = (WineShelfBlockEntity)blockEntity;
            Optional<Vec2> optional = WineShelfBlock.getRelativeHitCoordinatesForBlockFace(hitResult, (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_));
            if (optional.isEmpty()) {
                return InteractionResult.PASS;
            }
            int i = WineShelfBlock.getHitSlot(optional.get());
            if (state.m_61143_((Property)SLOT_CONTENTS.get(i)) != Slot.EMPTY) {
                WineShelfBlock.removeBottle(pLevel, pos, player, wineshelfblockentity, i);
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            }
            ItemStack itemstack = player.m_21120_(hand);
            if (itemstack.m_204117_(VDTags.WINE_SHELF_BOTTLES)) {
                WineShelfBlock.addBottle(pLevel, pos, player, wineshelfblockentity, itemstack, i);
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private static Optional<Vec2> getRelativeHitCoordinatesForBlockFace(BlockHitResult hitResult, Direction blocFace) {
        Direction direction = hitResult.m_82434_();
        if (blocFace != direction) {
            return Optional.empty();
        }
        BlockPos blockpos = hitResult.m_82425_().m_121945_(direction);
        Vec3 vec3 = hitResult.m_82450_().m_82492_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_());
        double d0 = vec3.m_7096_();
        double d1 = vec3.m_7098_();
        double d2 = vec3.m_7094_();
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> Optional.of(new Vec2((float)(1.0 - d0), (float)d1));
            case Direction.SOUTH -> Optional.of(new Vec2((float)d0, (float)d1));
            case Direction.WEST -> Optional.of(new Vec2((float)d2, (float)d1));
            case Direction.EAST -> Optional.of(new Vec2((float)(1.0 - d2), (float)d1));
            case Direction.DOWN, Direction.UP -> Optional.empty();
        };
    }

    private static int getHitSlot(Vec2 hitPos) {
        int i = hitPos.f_82471_ >= 0.5f ? 0 : 1;
        int j = WineShelfBlock.getSection(hitPos.f_82470_);
        return j + i * 2;
    }

    private static int getSection(float pX) {
        float f = 0.5f;
        if (pX < f) {
            return 0;
        }
        return 1;
    }

    private static void addBottle(Level level, BlockPos pos, Player player, WineShelfBlockEntity blockEntity, ItemStack bottleStack, int slot) {
        if (!level.f_46443_) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)bottleStack.m_41720_()));
            blockEntity.m_6836_(slot, bottleStack.m_41620_(1));
            if (player.m_7500_()) {
                bottleStack.m_41769_(1);
            }
            level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
        }
    }

    private static void removeBottle(Level level, BlockPos pos, Player player, WineShelfBlockEntity blockEntity, int slot) {
        if (!level.f_46443_) {
            ItemStack itemstack = blockEntity.m_7407_(slot, 1);
            if (!player.m_150109_().m_36054_(itemstack)) {
                player.m_36176_(itemstack, false);
            }
            level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
        }
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new WineShelfBlockEntity(pos, state);
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.m_60713_(newState.m_60734_())) {
            WineShelfBlockEntity wineshelfblockentity;
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof WineShelfBlockEntity && !(wineshelfblockentity = (WineShelfBlockEntity)blockentity).m_7983_()) {
                for (int i = 0; i < 4; ++i) {
                    ItemStack itemstack = wineshelfblockentity.m_8020_(i);
                    if (itemstack.m_41619_()) continue;
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemstack);
                }
                wineshelfblockentity.m_6211_();
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, movedByPiston);
        }
    }

    @NotNull
    public static VoxelShape makeShape(boolean has_support) {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.5, (double)0.0, (double)1.0, (double)0.625, (double)1.0));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0));
        shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.125, (double)0.875, (double)0.5625, (double)0.5, (double)1.0));
        if (has_support) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.4375, (double)0.625, (double)0.875, (double)0.5625, (double)1.0, (double)1.0));
        }
        return shape;
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
    }

    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    public int m_6782_(@NotNull BlockState state, Level level, @NotNull BlockPos pos) {
        if (level.m_5776_()) {
            return 0;
        }
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof WineShelfBlockEntity) {
            WineShelfBlockEntity wineshelfblockentity = (WineShelfBlockEntity)blockentity;
            return wineshelfblockentity.getLastInteractedSlot() + 1;
        }
        return 0;
    }

    public static Slot getSlotTypeForStack(ItemStack stack) {
        for (Slot slot : Slot.values()) {
            TagKey<Item> tag = slot.tag;
            if (tag == null || !stack.m_204117_(tag)) continue;
            return slot;
        }
        return stack.m_204117_(VDTags.WINE_SHELF_BOTTLES) ? Slot.WINE_BOTTLE : Slot.EMPTY;
    }

    public static Iterable<Block> getAllShelveBlocks() {
        return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> ForgeRegistries.BLOCKS.getKey(block) != null && "vampiresdelight".equals(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey(block)).m_135827_()) && block instanceof WineShelfBlock).collect(Collectors.toList());
    }

    public static enum Slot implements StringRepresentable
    {
        EMPTY("empty", null),
        BEER_BOTTLE("beer_bottle", VDTags.BEER_BOTTLES),
        WINE_BOTTLE("wine_bottle", VDTags.WINE_BOTTLES);

        private final String name;
        @Nullable
        private final TagKey<Item> tag;

        private Slot(String name, TagKey<Item> tag) {
            this.name = name;
            this.tag = tag;
        }

        @Nullable
        public TagKey<Item> getTag() {
            return this.tag;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

