/*
 * Decompiled with CFR 0.152.
 */
package net.salju.trialstowers.client.model;

import java.util.Arrays;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.salju.trialstowers.entity.Breeze;

public class BreezeModel<T extends Breeze>
extends HierarchicalModel<T> {
    private final ModelPart head;
    private final ModelPart[] rods;
    private final ModelPart root;

    public BreezeModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.rods = new ModelPart[3];
        this.root = root;
        Arrays.setAll(this.rods, i -> root.m_171324_(BreezeModel.getPartName(i)));
    }

    private static String getPartName(int i) {
        return "rod" + i;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(4, 24).m_171488_(-5.0f, -5.0f, -4.25f, 10.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        partdefinition.m_171599_(BreezeModel.getPartName(0), CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-1.0f, 0.0f, -6.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)1.0f));
        partdefinition.m_171599_(BreezeModel.getPartName(1), CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-1.0f, 0.0f, -6.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)1.0f));
        partdefinition.m_171599_(BreezeModel.getPartName(2), CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-1.0f, 0.0f, -6.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(Breeze brezo, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.head.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.rods[0].f_104204_ = -2.0944f;
        this.rods[1].f_104204_ = 2.0944f;
        this.rods[2].f_104204_ = 0.0f;
        int e = 360;
        float f = ((float)Math.floorMod(brezo.m_9236_().m_46467_(), (long)e) + ageInTicks) / (float)e;
        for (int i = 0; i < 3; ++i) {
            this.rods[i].f_104203_ = brezo.isCharging() ? 0.1746f : 0.3491f;
            this.rods[i].f_104204_ = this.rods[i].f_104204_ + (float)((double)f * Math.PI * (double)(brezo.isCharging() ? 45 : 25));
        }
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

