/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.teams.network.server;

import com.t2pellet.teams.TeamsHUD;
import com.t2pellet.teams.core.ModTeam;
import com.t2pellet.teams.core.TeamDB;
import com.t2pellet.teams.network.server.C2SModPacket;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class C2STeamKickPacket
implements C2SModPacket {
    String name;
    UUID toKick;

    public C2STeamKickPacket(String team, UUID playerToKick) {
        this.name = team;
        this.toKick = playerToKick;
    }

    public C2STeamKickPacket(FriendlyByteBuf byteBuf) {
        this.name = byteBuf.m_130277_();
        this.toKick = byteBuf.m_130259_();
    }

    @Override
    public void write(FriendlyByteBuf to) {
        to.m_130070_(this.name);
        to.m_130077_(this.toKick);
    }

    @Override
    public void handleServer(ServerPlayer player) {
        ModTeam team = TeamDB.getOrMakeDefault(player.f_8924_).getTeam(this.name);
        if (player != null && team.playerHasPermissions(player)) {
            ServerPlayer kicked = player.f_8924_.m_6846_().m_11259_(this.toKick);
            try {
                TeamDB.getOrMakeDefault(player.f_8924_).removePlayerFromTeam(kicked);
            }
            catch (ModTeam.TeamException ex) {
                TeamsHUD.LOGGER.error(ex.getMessage());
            }
        } else {
            TeamsHUD.LOGGER.error("Received packet to kick player, but the sender did not have permissions");
        }
    }
}

