/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.teams.network.client;

import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.t2pellet.teams.client.TeamsHUDClient;
import com.t2pellet.teams.network.client.S2CModPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class S2CTeamPlayerDataPacket
implements S2CModPacket {
    public static final String ID_KEY = "playerUuid";
    public static final String NAME_KEY = "playerName";
    public static final String SKIN_KEY = "playerSkin";
    public static final String SKIN_SIG_KEY = "playerSkinSignature";
    public static final String HEALTH_KEY = "playerHealth";
    public static final String HUNGER_KEY = "playerHunger";
    public static final String TYPE_KEY = "actionType";
    CompoundTag tag = new CompoundTag();

    public S2CTeamPlayerDataPacket(ServerPlayer player, Type type) {
        float health = player.m_21223_();
        int hunger = player.m_36324_().m_38702_();
        this.tag.m_128362_(ID_KEY, player.m_20148_());
        this.tag.m_128359_(TYPE_KEY, type.toString());
        switch (type) {
            case ADD: {
                this.tag.m_128359_(NAME_KEY, player.m_7755_().getString());
                PropertyMap properties = player.m_36316_().getProperties();
                Property skin = null;
                if (properties.containsKey((Object)"textures")) {
                    skin = (Property)properties.get((Object)"textures").iterator().next();
                }
                this.tag.m_128359_(SKIN_KEY, skin != null ? skin.getValue() : "");
                this.tag.m_128359_(SKIN_SIG_KEY, skin != null ? (skin.getSignature() != null ? skin.getSignature() : "") : "");
                this.tag.m_128350_(HEALTH_KEY, health);
                this.tag.m_128405_(HUNGER_KEY, hunger);
                break;
            }
            case UPDATE: {
                this.tag.m_128350_(HEALTH_KEY, health);
                this.tag.m_128405_(HUNGER_KEY, hunger);
            }
        }
    }

    public S2CTeamPlayerDataPacket(FriendlyByteBuf byteBuf) {
        this.tag = byteBuf.m_130260_();
    }

    @Override
    public void write(FriendlyByteBuf to) {
        to.m_130079_(this.tag);
    }

    @Override
    public void handleClient() {
        TeamsHUDClient.handleTeamPlayerDataPacket(this.tag);
    }

    public static enum Type {
        ADD,
        UPDATE,
        REMOVE;

    }
}

