/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.teams.core;

import com.t2pellet.teams.TeamsHUD;
import com.t2pellet.teams.core.IHasTeam;
import com.t2pellet.teams.core.ModComponents;
import com.t2pellet.teams.core.ModTeam;
import com.t2pellet.teams.network.client.S2CTeamDataPacket;
import com.t2pellet.teams.network.client.S2CTeamInvitedPacket;
import com.t2pellet.teams.platform.Services;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.scores.Scoreboard;
import org.jetbrains.annotations.Nullable;

public class TeamDB
extends SavedData {
    private static final String TEAMS_KEY = "teams";
    private Map<String, ModTeam> teams = new HashMap<String, ModTeam>();
    ServerLevel serverLevel;
    Scoreboard scoreboard;

    private TeamDB(ServerLevel serverLevel) {
        this.serverLevel = serverLevel;
        this.scoreboard = serverLevel.m_6188_();
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        this.toNBT(compoundTag);
        return compoundTag;
    }

    public Stream<ModTeam> getTeams() {
        return this.teams.values().stream();
    }

    public void addTeam(ModTeam team) throws ModTeam.TeamException {
        if (this.teams.containsKey(team.m_5758_())) {
            throw new ModTeam.TeamException(ModComponents.DUPLICATE_TEAM);
        }
        this.teams.put(team.m_5758_(), team);
        List players = this.serverLevel.m_7654_().m_6846_().m_11314_();
        Services.PLATFORM.sendToClients(new S2CTeamDataPacket(S2CTeamDataPacket.Type.ADD, team.name), players);
        this.m_77762_();
    }

    public ModTeam addTeam(String name, @Nullable ServerPlayer creator) throws ModTeam.TeamException {
        if (creator != null && ((IHasTeam)creator).hasTeam()) {
            throw new ModTeam.TeamException((Component)ModComponents.translatable("teams.error.alreadyinteam", creator.m_7755_().getString()));
        }
        ModTeam team = new ModTeam.Builder(name).complete(this);
        this.addTeam(team);
        if (creator != null) {
            team.addPlayer(creator);
        }
        List players = creator.m_20194_().m_6846_().m_11314_();
        Services.PLATFORM.sendToClients(new S2CTeamDataPacket(S2CTeamDataPacket.Type.ONLINE, team.name), players);
        this.m_77762_();
        return team;
    }

    public void removeTeam(ModTeam team) {
        this.teams.remove(team.m_5758_());
        MinecraftServer server = this.serverLevel.m_7654_();
        this.scoreboard.m_83475_(this.scoreboard.m_83489_(team.m_5758_()));
        team.clear();
        List players = server.m_6846_().m_11314_();
        Services.PLATFORM.sendToClients(new S2CTeamDataPacket(S2CTeamDataPacket.Type.REMOVE, team.name), players);
        this.m_77762_();
    }

    public boolean isEmpty() {
        return this.teams.isEmpty();
    }

    public boolean hasTeam(String team) {
        return this.teams.containsKey(team);
    }

    public ModTeam getTeam(ServerPlayer player) {
        return ((IHasTeam)player).getTeam();
    }

    public ModTeam getTeam(String name) {
        return this.teams.get(name);
    }

    public void invitePlayerToTeam(ServerPlayer player, ModTeam team) throws ModTeam.TeamException {
        if (((IHasTeam)player).hasTeam()) {
            throw new ModTeam.TeamException((Component)ModComponents.translatable("teams.error.alreadyinteam", player.m_7755_().getString()));
        }
        Services.PLATFORM.sendToClient(new S2CTeamInvitedPacket(team), player);
    }

    public void addPlayerToTeam(ServerPlayer player, ModTeam team) throws ModTeam.TeamException {
        if (((IHasTeam)player).hasTeam()) {
            throw new ModTeam.TeamException((Component)ModComponents.translatable("teams.error.alreadyinteam", player.m_7755_()));
        }
        team.addPlayer(player);
    }

    public void removePlayerFromTeam(ServerPlayer player) throws ModTeam.TeamException {
        ModTeam playerTeam = ((IHasTeam)player).getTeam();
        if (playerTeam == null) {
            throw new ModTeam.TeamException((Component)ModComponents.translatable("teams.error.notinteam", player.m_7755_().getString()));
        }
        playerTeam.removePlayer(player);
        if (playerTeam.isEmpty()) {
            this.removeTeam(playerTeam);
        }
    }

    public void fromNBT(CompoundTag compound) {
        this.teams.clear();
        ListTag list = compound.m_128437_(TEAMS_KEY, 10);
        for (Tag tag : list) {
            try {
                this.addTeam(ModTeam.fromNBT((CompoundTag)tag, this));
            }
            catch (ModTeam.TeamException ex) {
                TeamsHUD.LOGGER.error("Failed to load team from NBT" + ex.getMessage());
            }
        }
    }

    public void toNBT(CompoundTag compound) {
        ListTag list = new ListTag();
        for (ModTeam team : this.teams.values()) {
            list.add((Object)team.toNBT());
        }
        compound.m_128365_(TEAMS_KEY, (Tag)list);
    }

    static TeamDB get(ServerLevel serverLevel) {
        return (TeamDB)serverLevel.m_8895_().m_164858_(compoundTag -> TeamDB.loadStatic(compoundTag, serverLevel), TEAMS_KEY);
    }

    static TeamDB getOrMake(ServerLevel serverLevel) {
        return (TeamDB)serverLevel.m_8895_().m_164861_(compoundTag -> TeamDB.loadStatic(compoundTag, serverLevel), () -> new TeamDB(serverLevel), TEAMS_KEY);
    }

    public static TeamDB getOrMakeDefault(MinecraftServer server) {
        return TeamDB.getOrMake(server.m_129783_());
    }

    public static TeamDB loadStatic(CompoundTag compoundTag, ServerLevel level) {
        TeamDB id = new TeamDB(level);
        id.fromNBT(compoundTag);
        return id;
    }
}

