/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.teams.core;

import com.mojang.authlib.GameProfile;
import com.t2pellet.teams.core.IHasTeam;
import com.t2pellet.teams.core.TeamDB;
import com.t2pellet.teams.mixin.AdvancementAccessor;
import com.t2pellet.teams.network.client.S2CTeamClearPacket;
import com.t2pellet.teams.network.client.S2CTeamDataPacket;
import com.t2pellet.teams.network.client.S2CTeamInitPacket;
import com.t2pellet.teams.network.client.S2CTeamPlayerDataPacket;
import com.t2pellet.teams.network.client.S2CTeamUpdatePacket;
import com.t2pellet.teams.platform.Services;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;

public class ModTeam
extends Team {
    public final String name;
    private final TeamDB teamDB;
    private Set<UUID> players;
    private Map<UUID, ServerPlayer> onlinePlayers;
    private final Set<Advancement> advancements = new LinkedHashSet<Advancement>();
    private PlayerTeam scoreboardTeam;

    ModTeam(Scoreboard scoreboard, String name, TeamDB teamDB) {
        this.name = name;
        this.teamDB = teamDB;
        this.players = new HashSet<UUID>();
        this.onlinePlayers = new HashMap<UUID, ServerPlayer>();
        this.scoreboardTeam = scoreboard.m_83489_(name);
        if (this.scoreboardTeam == null) {
            this.scoreboardTeam = scoreboard.m_83492_(name);
        }
    }

    public UUID getOwner() {
        return (UUID)this.players.stream().findFirst().orElseThrow();
    }

    public boolean playerHasPermissions(ServerPlayer player) {
        return this.getOwner().equals(player.m_20148_()) || player.m_20310_(2);
    }

    public Collection<ServerPlayer> getOnlinePlayers() {
        return this.onlinePlayers.values();
    }

    public boolean isEmpty() {
        return this.players.isEmpty();
    }

    public boolean hasPlayer(ServerPlayer player) {
        return this.hasPlayer(player.m_20148_());
    }

    public boolean hasPlayer(UUID player) {
        return this.players.contains(player);
    }

    public void addPlayer(ServerPlayer player) {
        this.addPlayer(player.m_20148_());
    }

    public void removePlayer(ServerPlayer player) {
        this.removePlayer(player.m_20148_());
    }

    public void clear() {
        ArrayList<UUID> playersCopy = new ArrayList<UUID>(this.players);
        playersCopy.forEach(player -> this.removePlayer((UUID)player));
        this.advancements.clear();
    }

    public void addAdvancement(Advancement advancement) {
        this.advancements.add(advancement);
    }

    public Set<Advancement> getAdvancements() {
        return this.advancements;
    }

    public void playerOnline(ServerPlayer player, boolean sendPackets) {
        this.onlinePlayers.put(player.m_20148_(), player);
        ((IHasTeam)player).setTeam(this);
        if (sendPackets) {
            List players;
            Services.PLATFORM.sendToClient(new S2CTeamInitPacket(this.name, this.playerHasPermissions(player)), player);
            if (this.onlinePlayers.size() == 1) {
                players = this.teamDB.serverLevel.m_7654_().m_6846_().m_11314_();
                Services.PLATFORM.sendToClients(new S2CTeamDataPacket(S2CTeamDataPacket.Type.ONLINE, this.name), players);
            }
            players = this.getOnlinePlayers();
            Services.PLATFORM.sendToClients(new S2CTeamPlayerDataPacket(player, S2CTeamPlayerDataPacket.Type.ADD), players);
            for (ServerPlayer teammate : players) {
                Services.PLATFORM.sendToClient(new S2CTeamPlayerDataPacket(teammate, S2CTeamPlayerDataPacket.Type.ADD), player);
            }
        }
        for (Advancement advancement : this.getAdvancements()) {
            AdvancementProgress progress = player.m_8960_().m_135996_(advancement);
            for (String criterion : progress.m_8219_()) {
                player.m_8960_().m_135988_(advancement, criterion);
            }
        }
    }

    public Stream<UUID> getPlayerUuids() {
        return this.players.stream();
    }

    public void playerOffline(ServerPlayer player, boolean sendPackets) {
        this.onlinePlayers.remove(player.m_20148_());
        if (sendPackets) {
            List players;
            if (this.isEmpty()) {
                players = this.teamDB.serverLevel.m_7654_().m_6846_().m_11314_();
                Services.PLATFORM.sendToClients(new S2CTeamDataPacket(S2CTeamDataPacket.Type.OFFLINE, this.name), players);
            }
            players = this.getOnlinePlayers();
            Services.PLATFORM.sendToClients(new S2CTeamPlayerDataPacket(player, S2CTeamPlayerDataPacket.Type.REMOVE), players);
        }
    }

    private void addPlayer(UUID player) {
        ServerPlayer playerEntity;
        this.players.add(player);
        String playerName = this.getNameFromUUID(player);
        PlayerTeam playerScoreboardTeam = this.teamDB.scoreboard.m_83500_(playerName);
        if (playerScoreboardTeam == null || !playerScoreboardTeam.m_83536_((Team)this.scoreboardTeam)) {
            this.teamDB.scoreboard.m_6546_(playerName, this.scoreboardTeam);
        }
        if ((playerEntity = this.teamDB.serverLevel.m_7654_().m_6846_().m_11259_(player)) != null) {
            Services.PLATFORM.sendToClient(new S2CTeamUpdatePacket(this.name, playerName, S2CTeamUpdatePacket.Action.JOINED, true), playerEntity);
            Services.PLATFORM.sendToClients(new S2CTeamUpdatePacket(this.name, playerName, S2CTeamUpdatePacket.Action.JOINED, false), this.getOnlinePlayers());
            this.playerOnline(playerEntity, true);
            Set<Advancement> advancements = ((AdvancementAccessor)playerEntity.m_8960_()).getVisibleAdvancements();
            for (Advancement advancement : advancements) {
                if (!playerEntity.m_8960_().m_135996_(advancement).m_8193_()) continue;
                this.addAdvancement(advancement);
            }
        }
    }

    private void removePlayer(UUID player) {
        ServerPlayer playerEntity;
        this.players.remove(player);
        String playerName = this.getNameFromUUID(player);
        PlayerTeam playerScoreboardTeam = this.teamDB.scoreboard.m_83500_(playerName);
        if (playerScoreboardTeam != null && playerScoreboardTeam.m_83536_((Team)this.scoreboardTeam)) {
            this.teamDB.scoreboard.m_6519_(playerName, this.scoreboardTeam);
        }
        if ((playerEntity = this.teamDB.serverLevel.m_7654_().m_6846_().m_11259_(player)) != null) {
            this.playerOffline(playerEntity, true);
            Services.PLATFORM.sendToClient(new S2CTeamClearPacket(), playerEntity);
            Services.PLATFORM.sendToClient(new S2CTeamUpdatePacket(this.name, playerName, S2CTeamUpdatePacket.Action.LEFT, true), playerEntity);
            Services.PLATFORM.sendToClients(new S2CTeamUpdatePacket(this.name, playerName, S2CTeamUpdatePacket.Action.LEFT, false), this.getOnlinePlayers());
            ((IHasTeam)playerEntity).setTeam(null);
        }
    }

    private String getNameFromUUID(UUID id) {
        return this.teamDB.serverLevel.m_7654_().m_129927_().m_11002_(id).map(GameProfile::getName).orElseThrow();
    }

    static ModTeam fromNBT(CompoundTag compound, TeamDB teamDB) {
        ModTeam team = new Builder(compound.m_128461_("name")).setColour(ChatFormatting.m_126657_((String)compound.m_128461_("colour"))).setCollisionRule(Team.CollisionRule.m_83555_((String)compound.m_128461_("collision"))).setDeathMessageVisibilityRule(Team.Visibility.m_83579_((String)compound.m_128461_("deathMessages"))).setNameTagVisibilityRule(Team.Visibility.m_83579_((String)compound.m_128461_("nameTags"))).setFriendlyFireAllowed(compound.m_128471_("friendlyFire")).setShowFriendlyInvisibles(compound.m_128471_("showInvisible")).complete(teamDB);
        ListTag players = compound.m_128437_("players", 8);
        for (Tag elem : players) {
            team.addPlayer(UUID.fromString(elem.m_7916_()));
        }
        ListTag advancements = compound.m_128437_("advancement", 8);
        for (Tag adv : advancements) {
            ResourceLocation id = ResourceLocation.m_135820_((String)adv.m_7916_());
            team.addAdvancement(teamDB.serverLevel.m_7654_().m_129889_().m_136041_(id));
        }
        return team;
    }

    CompoundTag toNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("name", this.name);
        compound.m_128359_("colour", this.scoreboardTeam.m_7414_().m_126666_());
        compound.m_128359_("collision", this.scoreboardTeam.m_7156_().f_83543_);
        compound.m_128359_("deathMessages", this.scoreboardTeam.m_7468_().f_83567_);
        compound.m_128359_("nameTags", this.scoreboardTeam.m_7470_().f_83567_);
        compound.m_128379_("friendlyFire", this.scoreboardTeam.m_6260_());
        compound.m_128379_("showInvisible", this.scoreboardTeam.m_6259_());
        ListTag playerList = new ListTag();
        for (UUID player : this.players) {
            playerList.add((Object)StringTag.m_129297_((String)player.toString()));
        }
        compound.m_128365_("players", (Tag)playerList);
        ListTag advList = new ListTag();
        for (Advancement advancement : this.advancements) {
            advList.add((Object)StringTag.m_129297_((String)advancement.m_138327_().toString()));
        }
        compound.m_128365_("advancements", (Tag)advList);
        return compound;
    }

    public String m_5758_() {
        return this.name;
    }

    public MutableComponent m_6870_(Component name) {
        return this.scoreboardTeam.m_6870_(name);
    }

    public boolean m_6259_() {
        return this.scoreboardTeam.m_6259_();
    }

    public void setShowFriendlyInvisibles(boolean value) {
        this.scoreboardTeam.m_83362_(value);
    }

    public boolean m_6260_() {
        return this.scoreboardTeam.m_6260_();
    }

    public void setFriendlyFireAllowed(boolean value) {
        this.scoreboardTeam.m_83355_(value);
    }

    public Team.Visibility m_7470_() {
        return this.scoreboardTeam.m_7470_();
    }

    public void setNameTagVisibilityRule(Team.Visibility value) {
        this.scoreboardTeam.m_83346_(value);
    }

    public ChatFormatting m_7414_() {
        return this.scoreboardTeam.m_7414_();
    }

    public void setColour(ChatFormatting colour) {
        this.scoreboardTeam.m_83351_(colour);
    }

    public Collection<String> m_6809_() {
        return this.scoreboardTeam.m_6809_();
    }

    public Team.Visibility m_7468_() {
        return this.scoreboardTeam.m_7468_();
    }

    public void setDeathMessageVisibilityRule(Team.Visibility value) {
        this.scoreboardTeam.m_83358_(value);
    }

    public Team.CollisionRule m_7156_() {
        return this.scoreboardTeam.m_7156_();
    }

    public void setCollisionRule(Team.CollisionRule value) {
        this.scoreboardTeam.m_83344_(value);
    }

    public boolean equals(Object obj) {
        ModTeam team;
        return obj instanceof ModTeam && Objects.equals((team = (ModTeam)((Object)obj)).m_5758_(), this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public PlayerTeam getScoreboardTeam() {
        return this.scoreboardTeam;
    }

    public static class Builder {
        private final String name;
        private boolean showFriendlyInvisibles = Services.PLATFORM.getConfig().showInvisibleTeammates();
        private boolean friendlyFireAllowed = Services.PLATFORM.getConfig().friendlyFireEnabled();
        private Team.Visibility nameTagVisibilityRule = Services.PLATFORM.getConfig().nameTagVisibility();
        private ChatFormatting colour = Services.PLATFORM.getConfig().colour();
        private Team.Visibility deathMessageVisibilityRule = Services.PLATFORM.getConfig().deathMessageVisibility();
        private Team.CollisionRule collisionRule = Services.PLATFORM.getConfig().collisionRule();

        public Builder(String name) {
            this.name = name;
        }

        public Builder setShowFriendlyInvisibles(boolean showFriendlyInvisibles) {
            this.showFriendlyInvisibles = showFriendlyInvisibles;
            return this;
        }

        public Builder setFriendlyFireAllowed(boolean friendlyFireAllowed) {
            this.friendlyFireAllowed = friendlyFireAllowed;
            return this;
        }

        public Builder setNameTagVisibilityRule(Team.Visibility nameTagVisibilityRule) {
            this.nameTagVisibilityRule = nameTagVisibilityRule;
            return this;
        }

        public Builder setColour(ChatFormatting colour) {
            this.colour = colour;
            return this;
        }

        public Builder setDeathMessageVisibilityRule(Team.Visibility deathMessageVisibilityRule) {
            this.deathMessageVisibilityRule = deathMessageVisibilityRule;
            return this;
        }

        public Builder setCollisionRule(Team.CollisionRule collisionRule) {
            this.collisionRule = collisionRule;
            return this;
        }

        public ModTeam complete(TeamDB teamDB) {
            ModTeam team = new ModTeam(teamDB.scoreboard, this.name, teamDB);
            team.setShowFriendlyInvisibles(this.showFriendlyInvisibles);
            team.setFriendlyFireAllowed(this.friendlyFireAllowed);
            team.setNameTagVisibilityRule(this.nameTagVisibilityRule);
            team.setColour(this.colour);
            team.setDeathMessageVisibilityRule(this.deathMessageVisibilityRule);
            team.setCollisionRule(this.collisionRule);
            return team;
        }
    }

    public static class TeamException
    extends Exception {
        public TeamException(Component message) {
            super(message.getString());
        }
    }
}

