/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.teams.config;

import com.t2pellet.teams.platform.MultiloaderConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.world.scores.Team;
import net.minecraftforge.common.ForgeConfigSpec;

public class TomlConfig
implements MultiloaderConfig {
    @Override
    public boolean showInvisibleTeammates() {
        return (Boolean)Server.showInvisibleTeammates.get();
    }

    @Override
    public boolean friendlyFireEnabled() {
        return (Boolean)Server.friendlyFireEnabled.get();
    }

    @Override
    public Team.Visibility nameTagVisibility() {
        return (Team.Visibility)Server.nameTagVisibility.get();
    }

    @Override
    public ChatFormatting colour() {
        return (ChatFormatting)Server.colour.get();
    }

    @Override
    public Team.Visibility deathMessageVisibility() {
        return (Team.Visibility)Server.deathMessageVisibility.get();
    }

    @Override
    public Team.CollisionRule collisionRule() {
        return (Team.CollisionRule)Server.collisionRule.get();
    }

    @Override
    public boolean enableCompassHUD() {
        return (Boolean)Client.enableCompassHUD.get();
    }

    @Override
    public boolean enableStatusHUD() {
        return (Boolean)Client.enableStatusHUD.get();
    }

    @Override
    public int toastDuration() {
        return (Integer)Client.toastDuration.get();
    }

    @Override
    public boolean showHunger() {
        return (Boolean)Client.showHunger.get();
    }

    public static class Server {
        public static ForgeConfigSpec.BooleanValue showInvisibleTeammates;
        public static ForgeConfigSpec.BooleanValue friendlyFireEnabled;
        public static ForgeConfigSpec.EnumValue<Team.Visibility> nameTagVisibility;
        public static ForgeConfigSpec.EnumValue<ChatFormatting> colour;
        public static ForgeConfigSpec.EnumValue<Team.Visibility> deathMessageVisibility;
        public static ForgeConfigSpec.ConfigValue<Team.CollisionRule> collisionRule;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            showInvisibleTeammates = builder.define("show_invisible_teammates", true);
            friendlyFireEnabled = builder.define("friendly_fire_enabled", false);
            nameTagVisibility = builder.defineEnum("name_tag_visibility", (Enum)Team.Visibility.ALWAYS);
            colour = builder.defineEnum("colour", (Enum)ChatFormatting.BOLD);
            deathMessageVisibility = builder.defineEnum("death_message_visibility", (Enum)Team.Visibility.ALWAYS);
            collisionRule = builder.comment("Note that 'push own team' and 'push other teams' are swapped.").defineEnum("collision_rule", (Enum)Team.CollisionRule.PUSH_OWN_TEAM);
            builder.pop();
        }
    }

    public static class Client {
        public static ForgeConfigSpec.BooleanValue enableCompassHUD;
        public static ForgeConfigSpec.BooleanValue enableStatusHUD;
        public static ForgeConfigSpec.IntValue toastDuration;
        public static ForgeConfigSpec.BooleanValue showHunger;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("visual");
            enableCompassHUD = builder.define("enable_compass_hud", true);
            enableStatusHUD = builder.define("enable_status_hud", true);
            toastDuration = builder.comment("How long teams toast notifications should last").defineInRange("toast_duration", 5, 0, 100000000);
            showHunger = builder.comment("Show other team members' hunger").define("show_hunger", true);
            builder.pop();
        }
    }
}

