/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.teams.client.ui.menu;

import com.mojang.blaze3d.systems.RenderSystem;
import com.t2pellet.teams.TeamsHUD;
import com.t2pellet.teams.client.core.ClientTeam;
import com.t2pellet.teams.client.ui.menu.TexturedToggleWidget;
import com.t2pellet.teams.core.ModComponents;
import com.t2pellet.teams.network.server.C2STeamKickPacket;
import com.t2pellet.teams.platform.Services;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TeammateEntry
extends AbstractWidget {
    static final int WIDTH = 244;
    static final int HEIGHT = 24;
    private static final ResourceLocation TEXTURE = TeamsHUD.id("textures/gui/screen_background.png");
    private ImageButton kickButton;
    private TexturedToggleWidget favButton;
    private final Minecraft client = Minecraft.m_91087_();
    private final ClientTeam.Teammate teammate;
    private final int x;
    private final int y;

    public TeammateEntry(ClientTeam.Teammate teammate, int x, int y, boolean local) {
        super(x, y, 244, 24, (Component)ModComponents.literal(teammate.name));
        this.teammate = teammate;
        this.x = x;
        this.y = y;
        if (!local) {
            this.favButton = new TexturedToggleWidget(x + 244 - 12, y + 8, 8, 8, 0, 190, TEXTURE, button -> {
                if (ClientTeam.INSTANCE.isFavourite(teammate)) {
                    ClientTeam.INSTANCE.removeFavourite(teammate);
                } else {
                    ClientTeam.INSTANCE.addFavourite(teammate);
                }
            }, () -> ClientTeam.INSTANCE.isFavourite(teammate));
        }
        if (ClientTeam.INSTANCE.hasPermissions()) {
            this.kickButton = new ImageButton(x + 244 - 24, y + 8, 8, 8, 16, 190, TEXTURE, button -> {
                Services.PLATFORM.sendToServer(new C2STeamKickPacket(ClientTeam.INSTANCE.getName(), teammate.id));
                ClientTeam.INSTANCE.removePlayer(teammate.id);
            });
        }
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics);
        float scale = 0.5f;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(scale, scale, scale);
        graphics.m_280218_(this.teammate.skin, (int)((float)(this.x + 4) / scale), (int)((float)(this.y + 4) / scale), 32, 32, 32, 32);
        graphics.m_280168_().m_85849_();
        Font font = this.client.f_91062_;
        String string = this.teammate.name;
        Objects.requireNonNull(this.client.f_91062_);
        graphics.m_280056_(font, string, this.x + 24, this.y + 12 - 9 / 2, ChatFormatting.BLACK.m_126665_().intValue(), false);
        if (this.favButton != null) {
            this.favButton.m_88315_(graphics, mouseX, mouseY, delta);
        }
        if (this.kickButton != null) {
            this.kickButton.m_88315_(graphics, mouseX, mouseY, delta);
        }
    }

    private void renderBackground(GuiGraphics graphics) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280218_(TEXTURE, this.x, this.y, 0, 166, 244, 24);
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.FOCUSED;
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    public ImageButton getKickButton() {
        return this.kickButton;
    }

    public TexturedToggleWidget getFavButton() {
        return this.favButton;
    }
}

