/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.teams.client.ui.hud;

import com.t2pellet.teams.TeamsHUD;
import com.t2pellet.teams.client.core.ClientTeam;
import com.t2pellet.teams.core.ModComponents;
import com.t2pellet.teams.platform.Services;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class StatusOverlay {
    private static final ResourceLocation ICONS = TeamsHUD.id("textures/gui/hudicons.png");
    public boolean enabled = true;
    private final Minecraft client = Minecraft.m_91087_();
    private int offsetY = 0;

    public void render(GuiGraphics graphics) {
        this.offsetY = 0;
        List<ClientTeam.Teammate> teammates = ClientTeam.INSTANCE.getTeammates();
        int shown = 0;
        for (int i = 0; i < teammates.size() && shown < 4; ++i) {
            if (this.client.f_91074_.m_20148_().equals(teammates.get((int)i).id)) continue;
            this.renderStatus(graphics, teammates.get(i));
            ++shown;
        }
    }

    private void renderStatus(GuiGraphics graphics, ClientTeam.Teammate teammate) {
        if (!Services.PLATFORM.getConfig().enableStatusHUD() || !this.enabled) {
            return;
        }
        if (teammate.getHealth() <= 0.0f) {
            return;
        }
        int posX = (int)Math.round((double)this.client.m_91268_().m_85445_() * 0.003);
        int posY = this.client.m_91268_().m_85446_() / 4 - 5 + this.offsetY;
        String health = String.valueOf(Math.round(teammate.getHealth()));
        graphics.m_280218_(ICONS, posX + 20, posY, 0, 0, 9, 9);
        graphics.m_280430_(this.client.f_91062_, (Component)ModComponents.literal(health), posX + 32, posY, ChatFormatting.WHITE.m_126665_().intValue());
        if (Services.PLATFORM.getConfig().showHunger()) {
            String hunger = String.valueOf(teammate.getHunger());
            graphics.m_280218_(ICONS, posX + 46, posY, 9, 0, 9, 9);
            graphics.m_280430_(this.client.f_91062_, (Component)ModComponents.literal(hunger), posX + 58, posY, ChatFormatting.WHITE.m_126665_().intValue());
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        graphics.m_280218_(teammate.skin, posX + 4, this.client.m_91268_().m_85446_() / 2 - 34 + 2 * this.offsetY, 32, 32, 32, 32);
        graphics.m_280168_().m_85849_();
        graphics.m_280430_(this.client.f_91062_, (Component)Component.m_237113_((String)teammate.name), (int)Math.round((double)this.client.m_91268_().m_85445_() * 0.002) + 20, posY - 15, ChatFormatting.WHITE.m_126665_().intValue());
        this.offsetY += 46;
    }
}

