/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.teams.client.ui.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.t2pellet.teams.client.core.ClientTeam;
import com.t2pellet.teams.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class CompassOverlay {
    private static final int HUD_WIDTH = 182;
    private static final int HUD_HEIGHT = 5;
    private static final int MIN_DIST = 12;
    private static final int MAX_DIST = 128;
    private static final float MIN_SCALE = 0.2f;
    private static final float MAX_SCALE = 0.4f;
    private static final float MIN_ALPHA = 0.4f;
    static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    public boolean enabled = true;
    private final Minecraft client = Minecraft.m_91087_();
    private boolean isShowing = false;

    public boolean isShowing() {
        return this.isShowing;
    }

    public void render(GuiGraphics graphics) {
        if (!Services.PLATFORM.getConfig().enableCompassHUD() || !this.enabled) {
            this.isShowing = false;
            return;
        }
        boolean renderedAnyHead = false;
        float minScale = 1.0f;
        for (ClientTeam.Teammate teammate : ClientTeam.INSTANCE.getTeammates()) {
            Player player;
            if (this.client.f_91074_.m_20148_().equals(teammate.id) || (player = this.client.f_91073_.m_46003_(teammate.id)) == null) continue;
            double rotationHead = this.caculateRotationHead();
            float scaleFactor = this.calculateScaleFactor(player);
            if (scaleFactor < minScale) {
                minScale = scaleFactor;
            }
            double renderFactor = this.calculateRenderFactor(player, rotationHead);
            this.renderHUDHead(graphics, teammate.skin, scaleFactor, renderFactor);
            renderedAnyHead = true;
        }
        if (ClientTeam.INSTANCE.isInTeam() && !ClientTeam.INSTANCE.isTeamEmpty() && renderedAnyHead) {
            int x = (this.client.m_91268_().m_85445_() - 182) / 2;
            int y = 7;
            float alpha = (1.0f - minScale) * 0.6f + 0.4f;
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            graphics.m_280218_(GUI_ICONS_LOCATION, x, y, 0, 74, 182, 5);
            RenderSystem.disableBlend();
            this.isShowing = true;
        } else {
            this.isShowing = false;
        }
    }

    private double caculateRotationHead() {
        double rotationHead = this.client.f_91074_.m_6080_() % 360.0f;
        if (rotationHead > 180.0) {
            rotationHead -= 360.0;
        } else if (rotationHead < -180.0) {
            rotationHead = 360.0 + rotationHead;
        }
        return rotationHead;
    }

    private float calculateScaleFactor(Player player) {
        double diffPosX = player.m_20182_().f_82479_ - this.client.f_91074_.m_20182_().f_82479_;
        double diffPosZ = player.m_20182_().f_82481_ - this.client.f_91074_.m_20182_().f_82481_;
        double magnitude = Math.sqrt(diffPosX * diffPosX + diffPosZ * diffPosZ);
        if (magnitude >= 128.0) {
            return 1.0f;
        }
        if (magnitude <= 12.0) {
            return 0.0f;
        }
        return (float)((magnitude - 12.0) / 116.0);
    }

    private double calculateRenderFactor(Player player, double rotationHead) {
        double renderFactor;
        double diffPosX = player.m_20182_().f_82479_ - this.client.f_91074_.m_20182_().f_82479_;
        double diffPosZ = player.m_20182_().f_82481_ - this.client.f_91074_.m_20182_().f_82481_;
        double magnitude = Math.sqrt(diffPosX * diffPosX + diffPosZ * diffPosZ);
        double angle = Math.atan((diffPosZ /= magnitude) / (diffPosX /= magnitude)) * 180.0 / Math.PI + 90.0;
        if (diffPosX >= 0.0) {
            angle -= 180.0;
        }
        if ((renderFactor = (angle - rotationHead) / 180.0) > 1.0) {
            renderFactor -= 2.0;
        }
        if (renderFactor < -1.0) {
            renderFactor = 2.0 + renderFactor;
        }
        return renderFactor;
    }

    private void renderHUDHead(GuiGraphics graphics, ResourceLocation skin, float scaleFactor, double renderFactor) {
        int scaledWidth = this.client.m_91268_().m_85445_();
        int x = (int)((double)(scaledWidth / 2 - 45) + renderFactor * 182.0 / 2.0 + 41.0);
        int y = 14;
        float sizeFactor = scaleFactor * 0.2f + 0.2f;
        float alphaFactor = (1.0f - scaleFactor) * 0.6f + 0.4f;
        graphics.m_280168_().m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaFactor);
        graphics.m_280168_().m_85841_(sizeFactor, sizeFactor, sizeFactor);
        if (1.0 - Math.abs(renderFactor) < (double)Math.min(alphaFactor, 0.6f)) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(1.0 - Math.abs(renderFactor))));
            graphics.m_280218_(skin, Math.round((float)x / sizeFactor), Math.round((float)y / sizeFactor), 32, 32, 32, 32);
        } else {
            graphics.m_280218_(skin, Math.round((float)x / sizeFactor), Math.round((float)y / sizeFactor), 32, 32, 32, 32);
        }
        RenderSystem.disableBlend();
        graphics.m_280168_().m_85849_();
    }
}

