/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.teams.client.core;

import com.t2pellet.teams.TeamsHUD;
import com.t2pellet.teams.client.core.ClientTeam;
import com.t2pellet.teams.client.ui.menu.TeamsLonelyScreen;
import com.t2pellet.teams.client.ui.menu.TeamsMainScreen;
import com.t2pellet.teams.client.ui.menu.TeamsScreen;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;

class ClientTeamImpl
implements ClientTeam {
    private Minecraft client = Minecraft.m_91087_();
    private Map<UUID, ClientTeam.Teammate> teammates = new HashMap<UUID, ClientTeam.Teammate>();
    private Set<UUID> favourites = new HashSet<UUID>();
    private boolean initialized = false;
    private String name = "";
    private boolean hasPerms = false;

    ClientTeamImpl() {
    }

    @Override
    public void init(String name, boolean hasPermissions) {
        if (this.initialized) {
            throw new IllegalArgumentException("Cannot initialize already initialized team. Did you clear it first?");
        }
        this.name = name;
        this.hasPerms = hasPermissions;
        this.initialized = true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasPermissions() {
        return this.hasPerms;
    }

    @Override
    public boolean isInTeam() {
        return this.initialized;
    }

    @Override
    public boolean isTeamEmpty() {
        return this.teammates.size() == 0 || this.teammates.size() == 1 && this.teammates.get(this.client.f_91074_.m_20148_()) != null;
    }

    @Override
    public List<ClientTeam.Teammate> getTeammates() {
        return this.teammates.values().stream().toList();
    }

    @Override
    public boolean hasPlayer(UUID player) {
        return this.teammates.containsKey(player);
    }

    @Override
    public void addPlayer(UUID player, String name, ResourceLocation skin, float health, int hunger) {
        this.teammates.put(player, new ClientTeam.Teammate(player, name, skin, health, hunger));
        Screen screen = this.client.f_91080_;
        if (screen instanceof TeamsMainScreen) {
            TeamsMainScreen screen2 = (TeamsMainScreen)screen;
            screen2.refresh();
        } else if (player.equals(this.client.f_91074_.m_20148_()) && this.client.f_91080_ instanceof TeamsScreen) {
            this.client.m_91152_(null);
        }
    }

    @Override
    public void updatePlayer(UUID player, float health, int hunger) {
        ClientTeam.Teammate teammate = this.teammates.get(player);
        if (teammate != null) {
            teammate.health = health;
            teammate.hunger = hunger;
        } else {
            TeamsHUD.LOGGER.warn("Tried updating player with UUID " + player + "but they are not in this clients team");
        }
    }

    @Override
    public void removePlayer(UUID player) {
        this.teammates.remove(player);
        Screen screen = this.client.f_91080_;
        if (screen instanceof TeamsMainScreen) {
            TeamsMainScreen screen2 = (TeamsMainScreen)screen;
            if (this.teammates.isEmpty() || player.equals(this.client.f_91074_.m_20148_())) {
                this.client.m_91152_(screen2.parent);
            } else {
                screen2.refresh();
            }
        } else {
            screen = this.client.f_91080_;
            if (screen instanceof TeamsLonelyScreen) {
                TeamsLonelyScreen screen3 = (TeamsLonelyScreen)screen;
                screen3.refresh();
            }
        }
    }

    @Override
    public List<ClientTeam.Teammate> getFavourites() {
        return this.favourites.stream().filter(this.teammates::containsKey).map(this.teammates::get).toList();
    }

    @Override
    public boolean isFavourite(ClientTeam.Teammate player) {
        return this.favourites.contains(player.id);
    }

    @Override
    public void addFavourite(ClientTeam.Teammate player) {
        this.favourites.add(player.id);
    }

    @Override
    public void removeFavourite(ClientTeam.Teammate player) {
        this.favourites.remove(player.id);
    }

    @Override
    public void reset() {
        this.teammates.clear();
        this.name = "";
        this.hasPerms = false;
        this.initialized = false;
        if (this.client.f_91080_ instanceof TeamsScreen) {
            this.client.m_91152_((Screen)new TeamsLonelyScreen(null));
        }
    }
}

